import org.codehaus.groovy.grails.plugins.springsecurity.Secured

class AppCoreController extends BaseController {

    def authenticateService

    def index = { redirect(action:home,params:params) }

    // the delete, save and update actions only accept POST requests
    //def allowedMethods = [delete:'POST', save:'POST', update:'POST']

    def home = {
    }

    def options = {
    }

    def changePassword = {
        //def principal = authenticateService.principal()
        //println principal.getAuthorities()

        if (request.method == 'GET') {
            def personInstance = Person.get(authenticateService.userDomain().id)
            return [ personInstance : personInstance ]       
        }  

        if (request.method == 'POST') {
            def personInstance = Person.get(authenticateService.userDomain().id)

            if(params.repeatPass == params.pass) {
                personInstance.pass = params.pass
                personInstance.password = authenticateService.encodePassword(personInstance.pass)

                if (!personInstance.hasErrors() && personInstance.save()) {
                    //userCache.removeUserFromCache(personInstance.loginName)
                    flash.message = "Password changed successfully."
                    redirect(action:options)
                }
                else {
                    render(view:'changePassword',model:[personInstance:personInstance])
                }
            }
            else {
                flash.message = "Passwords must match."
//                 personInstance.addToErrors("Passwords must match.")
                render(view:'changePassword',model:[personInstance:personInstance])
            }
                
        }  
    }

    @Secured(['ROLE_Manager'])   
    def manager = {
    }

    @Secured(['ROLE_AppAdmin'])   
    def admin = {
    }

}