<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>Supplier List</title>
        <filterpane:includes />
        <nav:resources override="true"/>
    </head>
    <body>
        <div class="nav">
            <nav:renderSubItems group="navAlt"/>
        </div>
        <div class="body">
            <g:render template="/shared/messages" />

            <filterpane:currentCriteria domainBean="Supplier"
                                        action="list"
                                        dateFormat="EEE, dd-MMM-yyyy"
                                        removeImgDir="images"
                                        removeImgFile="bullet_delete.png"
                                        title="Search"/>

            <div class="paginateButtons">
                Results: ${supplierInstanceList.size()} / ${supplierInstanceTotal}
                <span class="searchButtons">
                    <filterpane:filterButton text="Search" appliedText="Change Search" />
                </span>
            </div>

            <br />

            <g:if test="${supplierInstanceList.size() > 0}">

                <div class="list">
                    <table>
                        <thead>
                        <tr>

                            <g:sortableColumn property="id" title="Id" params="${filterParams}" />

                            <g:sortableColumn property="name" title="Name" params="${filterParams}" />

                            <g:sortableColumn property="description" title="Description" params="${filterParams}" />

                            <g:sortableColumn property="isActive" title="Is Active" params="${filterParams}" />

                            <th>Supplier Type</th>

                            <th></th>

                        </tr>
                        </thead>
                        <tbody>
                        <g:each in="${supplierInstanceList}" status="i" var="supplierInstance">
                            <tr class="${(i % 2) == 0 ? 'clickableOdd' : 'clickableEven'}">

                                <td onclick='window.location = "${request.getContextPath()}/supplierDetailed/show/${supplierInstance.id}"'>
                                    ${fieldValue(bean:supplierInstance, field:'id')}
                                </td>

                                <td onclick='window.location = "${request.getContextPath()}/supplierDetailed/show/${supplierInstance.id}"'>
                                    ${fieldValue(bean:supplierInstance, field:'name')}
                                </td>

                                <td onclick='window.location = "${request.getContextPath()}/supplierDetailed/show/${supplierInstance.id}"'>
                                    ${fieldValue(bean:supplierInstance, field:'description')}
                                </td>

                                <td onclick='window.location = "${request.getContextPath()}/supplierDetailed/show/${supplierInstance.id}"'>
                                    ${fieldValue(bean:supplierInstance, field:'isActive')}
                                </td>

                                <td onclick='window.location = "${request.getContextPath()}/supplierDetailed/show/${supplierInstance.id}"'>
                                    ${fieldValue(bean:supplierInstance, field:'supplierType')}
                                </td>

                                <td class="notClickable">
                                    <g:link action="show" id="${supplierInstance.id}">
                                        <img  src="${resource(dir:'images/skin',file:'database_go.png')}" alt="Show" />
                                    </g:link>
                                </td>

                            </tr>
                        </g:each>
                        </tbody>
                    </table>
                </div>
            </g:if>

            <div class="paginateButtons">
                <g:paginate total="${supplierInstanceTotal}" params="${filterParams}" />
            </div>

            <filterpane:filterPane domainBean="Supplier"
                                   title="Search"
                                   action="list"
                                   class="overlayPane"
                                   associatedProperties="supplierType.name"
                                   filterPropertyValues="${['supplierType.name':[values: associatedPropertyValues.supplierTypeList]]}" />

        </div>
    </body>
</html>
