class Task {
    TaskGroup taskGroup
    TaskStatus taskStatus
    TaskPriority taskPriority
    TaskType taskType
    Task    parentTask
    Person leadPerson
    String description
    String comment = ""
    Date targetStartDate = new Date()
    Date targetCompletionDate = new Date()
    boolean isScheduled = false
    boolean isApproved = false
    boolean isActive = true

    static hasMany = [entries: Entry, 
                        modifications: Modification, 
                        assignedPersons: Person, 
                        subTasks: Task]

    static belongsTo = [TaskGroup, TaskStatus, Task, Person]

    static constraints = {
        targetStartDate()
        description(blank:false,maxSize:75)
        leadPerson()
        taskPriority()
        taskStatus()
        parentTask(blank: true, nullable:true)
        comment(maxSize:255)
        
    }

    String toString() {"${this.description}"}
}
