<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>Work Load</title>
        <resource:dateChooser />
    </head>
    <body>
        <div class="nav">
            <h1>Work Load</h1>
        </div>
        <div class="body">
            <g:render template="/shared/messages" />

            <div class="paginateButtons">
                <span class="searchButtons">
                    <a href='' onclick="showElement('searchPane'); return false;">Search</a>
                </span>
            </div>

            <br />


            <g:if test="${workLoadGroups.size() > 0}">
                <h1>Assigned Groups</h1>
            </g:if>
            <g:else>
                <h1>No Assigned Groups Found</h1>
            </g:else>
                    <div class="list">
                        <table>
                            <thead>
                                <tr>
                                    <th>Assigned Group</th>
                                    <th>Duration</th>
                                </tr>
                            </thead>
                            <tbody>
                                <g:each in="${workLoadGroups}" status="i" var="workLoadGroup">
                                        <tr class="${(i % 2) == 0 ? 'clickableOdd' : 'clickableEven'}">

                                            <td class="notClickable">
                                                ${workLoadGroup.key}
                                            </td>

                                            <td class="notClickable">
                                                ${workLoadGroup.value.hours}:<g:formatNumber number="${workLoadGroup.value.minutes}" type="number" minIntegerDigits="2" />
                                            </td>

                                        </tr>
                                </g:each>
                            </tbody>
                                <tr class="total">
                                    <td>
                                        Total
                                    </td>
                                    <td>
                                        ${totalHours}:<g:formatNumber number="${totalMinutes}" type="number" minIntegerDigits="2" />
                                    </td>
                                </tr>
                        </table>
                    </div>

            <br />

            <h1>Task Results: ${tasks.size()} / ${tasks.totalCount}</h1>

            <g:if test="${tasks.size() > 0}">
                <div class="list">
                    <table>
                        <thead>
                            <tr>

                                <th>
                                        <img  src="${resource(dir:'images/skin',file:'flag_red.png')}" alt="Flag" />
                                </th>

                                <th>Target Start Date</th>

                                <th>Description</th>

                                <th>Group</th>

                                <th>Type</th>

                                <th>Priority</th>

                                <th>Status</th>

                                <th></th>

                            </tr>
                        </thead>
                        <tbody>
                        <g:each in="${tasks}" status="i" var="taskInstance">
                        <tr class="${(i % 2) == 0 ? 'clickableOdd' : 'clickableEven'}">

                                <td class="idColumn" onclick='window.location = "${request.getContextPath()}/taskDetailed/show/${taskInstance.id}"'>
                                    <g:if test="${taskInstance.attentionFlag}">
                                        <img  src="${resource(dir:'images/skin',file:'flag_red.png')}" alt="Flag" />
                                    </g:if>
                                </td>

                                <td onclick='window.location = "${request.getContextPath()}/taskDetailed/show/${taskInstance.id}"'>
                                    <g:formatDate date="${taskInstance.targetStartDate}" format="EEE, dd-MMM-yyyy"/>
                                </td>

                                <td onclick='window.location = "${request.getContextPath()}/taskDetailed/show/${taskInstance.id}"'>
                                    <b>
                                        Task #${fieldValue(bean:taskInstance, field:'id')}<br />
                                        ${fieldValue(bean:taskInstance, field:'description')}
                                    </b>
                                    <br />
                                    <br />
                                    <g:if test="${taskInstance.primaryAsset}">
                                        ${fieldValue(bean:taskInstance, field:'primaryAsset')}<br />
                                    </g:if>
                                    <g:each in="${taskInstance.assignedGroups}" status="j" var="assignedGroup">
                                        ${assignedGroup.encodeAsHTML()}<br />
                                    </g:each>
                                    <g:each in="${taskInstance.assignedPersons}" status="k" var="assignedPerson">
                                        ${assignedPerson.encodeAsHTML()}<br />
                                    </g:each>
                                    <g:each in="${taskInstance.entries}" status="m" var="entry">
                                        <g:if test="${entry.entryType.id == 3}">
                                            <em>${'WD: ' +entry.toShortString().encodeAsHTML()}</em><br />
                                        </g:if>
                                    </g:each>
                                    <g:if test="${taskInstance.subTasks}">
                                        Sub Tasks: ${taskInstance.subTasks.size()}<br />
                                    </g:if>
                                </td>

                                <td onclick='window.location = "${request.getContextPath()}/taskDetailed/show/${taskInstance.id}"'>
                                    ${fieldValue(bean:taskInstance, field:'taskGroup')}
                                </td>

                                <td onclick='window.location = "${request.getContextPath()}/taskDetailed/show/${taskInstance.id}"'>
                                    ${fieldValue(bean:taskInstance, field:'taskType')}
                                </td>

                                <td onclick='window.location = "${request.getContextPath()}/taskDetailed/show/${taskInstance.id}"'>
                                    ${fieldValue(bean:taskInstance, field:'taskPriority')}
                                </td>

                                <td onclick='window.location = "${request.getContextPath()}/taskDetailed/show/${taskInstance.id}"'>
                                    ${fieldValue(bean:taskInstance, field:'taskStatus')}
                                </td>

                                <td class="notClickable">
                                    <g:link action="show" id="${taskInstance.id}">
                                        <img  src="${resource(dir:'images/skin',file:'database_go.png')}" alt="Show" />
                                    </g:link>
                                </td>

                            </tr>
                        </g:each>
                        </tbody>
                    </table>
                </div>
            </g:if>

            <!-- Start Search Pane -->
            <div class="overlayPane" id="searchPane" style="display:none;">
                <h2>Search</h2>
                <g:form method="post" controller="taskDetailed">
                    <table>
                        <tbody>

                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="date">Date:</label>
                                </td>
                                <td valign="top" class="value">
                                    <richui:dateChooser name="startDate" format="dd-MM-yyyy" value="${startDate}" />
                                    to
                                    <richui:dateChooser name="endDate" format="dd-MM-yyyy" value="${endDate}" />
                                </td>
                            </tr>

                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label>Task Status:</label>
                                </td>
                                <td valign="top" class="value">
                                    <custom:checkBoxList name="taskStatusList"
                                                                            from="${TaskStatus.findAllByIsActive(true)}"
                                                                            value="${taskStatusList?.collect{it.id}}"
                                                                            optionKey="id"
                                                                            sortBy="name"
                                                                            linkController="taskStatusDetailed"
                                                                            linkAction="show"
                                                                            height="150px"/>
                                </td>
                            </tr>

                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label>Task Groups:</label>
                                </td>
                                <td valign="top" class="value">
                                    <custom:checkBoxList name="taskGroups"
                                                                            from="${TaskGroup.findAllByIsActive(true)}"
                                                                            value="${taskGroups?.collect{it.id}}"
                                                                            optionKey="id"
                                                                            sortBy="name"
                                                                            linkController="taskGroupDetailed"
                                                                            linkAction="show"
                                                                            height="150px"/>
                                </td>
                            </tr>

                        </tbody>
                    </table>
                    <div class="buttons">
                        <span class="button">
                            <g:actionSubmit class="save" value="Update" action="workLoad" />
                            <g:actionSubmit class="cancel" value="${g.message(code:'fp.tag.filterPane.button.cancel.text', default:'Cancel')}" onclick="return hideElement('searchPane');" />
                        </span>
                    </div>
                </g:form>
            </div> <!-- end search pane -->

        </div> <!--body-->
    </body>
</html>
