<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>Show Task #${taskInstance.id}</title>
        <nav:resources override="true"/>
        <resource:tabView skin="tabviewCustom" />
    </head>
    <body>
        <div class="nav">
            <nav:renderSubItems group="nav"/>
        </div>
        <div class="body">
            <g:render template="/shared/messages" />
            <g:if test="${taskInstance.trash}" >
                <div class="errors">
                        <ul><li>This task is in the trash bin, but can be restored if required.<li><ul>
                </div>
            </g:if>
            <g:hasErrors bean="${taskInstance}">
            <div class="errors">
                <g:renderErrors bean="${taskInstance}" as="list" />
            </div>
            </g:hasErrors>

            <div class="tabHeader">
                <h1>
                    Task #${taskInstance.id}

                    <g:if test="${taskInstance.approved}" >
                        <img  src="${resource(dir:'images/skin',file:'cog.png')}" alt="Approved" title="Approved" />
                    </g:if>
                    <g:if test="${taskRecurringScheduleInstance?.enabled}" >
                        <img  src="${resource(dir:'images/skin',file:'arrow_refresh.png')}" alt="Recurrence Enabled" title="Recurrence Enabled" />
                    </g:if>
                    <g:if test="${taskInstance.taskStatus.id == 2}" >
                        <img  src="${resource(dir:'images/skin',file:'arrow_right.png')}" alt="In Progress" title="In Progress" />
                    </g:if>
                    <g:if test="${taskInstance.attentionFlag}" >
                        <img  src="${resource(dir:'images/skin',file:'flag_red.png')}" alt="Attention Flag" title="Attention Flag" />
                    </g:if>
                    <g:if test="${taskInstance.taskStatus.id == 3}" >
                        <img  src="${resource(dir:'images/skin',file:'tick.png')}" alt="Complete" title="Complete" />
                    </g:if>
                </h1>
                <g:if test="${taskInstance.primaryAsset}" >
                    ${fieldValue(bean:taskInstance, field:'primaryAsset')}:
                </g:if>
                ${fieldValue(bean:taskInstance, field:'description')}
                <g:if test="${taskInstance.safetyRequirement}" >
                    <img  src="${resource(dir:'images/skin',file:'lightning.png')}" alt="Safety Requirement" title="Safety Requirement" />
                    Safety
                </g:if>
                <g:if test="${taskInstance.regulatoryRequirement}" >
                    <img  src="${resource(dir:'images/skin',file:'script_lightning.png')}" alt="Regulatory Requirement" title="Regulatory Requirement" />
                    Regulatory
                </g:if>
                <g:if test="${taskInstance.mandatoryRequirement}" >
                    <img  src="${resource(dir:'images/skin',file:'script.png')}" alt="Mandatory Requirement" title="Mandatory Requirement" />
                    Mandatory
                </g:if>
            </div>

            <br/>

            <richui:tabView id="tabView">

                <richui:tabLabels>
                    <richui:tabLabel selected="${showTab.task}" title="Details" />
                    <g:if test="${taskProcedureExits}">
                        <richui:tabLabel selected="${showTab.procedure}" title="Procedure (!)" />
                    </g:if>
                    <g:else>
                        <richui:tabLabel selected="${showTab.procedure}" title="Procedure" />
                    </g:else>
                    <g:if test="${taskRecurringScheduleExits}">
                        <richui:tabLabel selected="${showTab.recurrence}" title="Recurrence (!)" />
                    </g:if>
                    <g:else>
                        <richui:tabLabel selected="${showTab.recurrence}" title="Recurrence" />
                    </g:else>
                    <g:if test="${!inventoryMovementList.isEmpty()}">
                        <richui:tabLabel selected="${showTab.inventory}" title="Inventory (${inventoryMovementList.size()})" />
                    </g:if>
                    <g:else>
                        <richui:tabLabel selected="${showTab.inventory}" title="Inventory (0)" />
                    </g:else>
                    <g:if test="${subTaskInstanceTotal > 0}">
                        <richui:tabLabel selected="${showTab.subTasks}" title="Sub Tasks (${subTaskInstanceTotal})" />
                    </g:if>
                    <g:else>
                        <richui:tabLabel selected="${showTab.subTasks}" title="Sub Tasks (0)" />
                    </g:else>
                </richui:tabLabels>

                <richui:tabContents>

                    <richui:tabContent>
                        <g:render template="showTaskTab" />
                    </richui:tabContent>

                    <richui:tabContent>
                        <g:render template="showProcedureTab" />
                    </richui:tabContent>

                    <richui:tabContent>
                        <g:render template="showRecurrenceTab" />
                    </richui:tabContent>

                    <richui:tabContent>
                        <g:render template="showInventoryTab" />
                    </richui:tabContent>

                    <richui:tabContent>
                        <g:render template="showSubTaskTab" />
                    </richui:tabContent>

                </richui:tabContents>
            </richui:tabView>

        </div> <!--body-->
    </body>
</html>
