<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
    <meta name="layout" content="main" />
    <title>Start</title>
    <nav:resources override="true"/>
    <resource:tabView skin="tabviewCustom" />
    <resource:dateChooser />
</head>
    <body>
        <div class="nav">
            <nav:renderSubItems group="nav"/>
        </div>
        <div class="body">
            <g:if test="${flash.message}">
                <div class="message">${flash.message}</div>
            </g:if>
            <g:hasErrors bean="${appCore}">
                <div class="errors">
                    <g:renderErrors bean="${appCore}" as="list" />
                </div>
            </g:hasErrors>

            <richui:tabView id="tabView">

                <richui:tabLabels>
                    <richui:tabLabel selected="true" title="Quick Links" />
                    <richui:tabLabel selected="${0}" title="Reports" />
                    <richui:tabLabel selected="${0}" title="Options" />
                    <richui:tabLabel selected="${0}" title="About" />
                </richui:tabLabels>

                <richui:tabContents>

<!-- Tasks tab -->
                    <richui:tabContent>
                        <br />
                        <br />
                        <div class="dialog">
                            <table>
                                <tbody>

                                    <tr class="prop">
                                        <td valign="top" class="name">
                                            <label>My Tasks:</label>
                                        </td>
                                        <td valign="top" class="value">
                                            <g:link controller="taskDetailed"
                                                            action="search"
                                                            params="[quickSearch: 'myTodays']">
                                                            Today
                                            </g:link>
                                        </td>
                                    </tr>
            
                                    <tr class="prop">
                                        <td valign="top" class="name">
                                            <label>All Tasks:</label>
                                        </td>
                                        <td valign="top" class="value">
                                            <g:link controller="taskDetailed" 
                                                            action="search"
                                                            params="[quickSearch: 'pastWeek']">
                                                            Past Week
                                            </g:link>
                                            <br />
                                            <g:link controller="taskDetailed" 
                                                            action="searchCalendar"
                                                            params="[quickSearch: 'searchPlannersRange']">
                                                            Calendar
                                            </g:link>
                                        </td>
                                    </tr>

<!--                                    More Quick Links:
                                    Open Tasks
                                    Closed Tasks
                                    Tasks I lead.
                                    Week calender
                                    Recent
                                    Today's Entries
                                    My Entries.
                                    Date ranges-->

                                </tbody>
                            </table>
                        </div> <!--End dialog-->
                    </richui:tabContent>
<!-- End Tasks tab -->

<!-- Reports tab -->
                    <richui:tabContent>
                        <br />
                        <br />
                        <div class="dialog">
                            <table>
                                <tbody>

                                    <tr class="prop">
                                        <td valign="top" class="name">
                                            <label>Frequently Used:</label>
                                        </td>
                                        <td valign="top" class="value">
                                            <g:jasperReport controller="report"
                                                                            action="reactiveRatio"
                                                                            jasper="reactiveRatio"
                                                                            name="Reactive Ratio"
                                                                            format="PDF, XLS">
                                                <richui:dateChooser name="startDate" format="dd-MM-yyyy" value="${new Date()-7}" />
                                                to
                                                <richui:dateChooser name="endDate" format="dd-MM-yyyy" value="${new Date()}" />
                                            </g:jasperReport>
                                            <br />
                                            <g:jasperReport controller="report"
                                                                            action="immediateCallouts"
                                                                            jasper="immediateCallouts"
                                                                            name="Immediate Callouts"
                                                                            format="PDF, XLS">
                                                <richui:dateChooser name="startDate" format="dd-MM-yyyy" value="${new Date()-7}" />
                                                to
                                                <richui:dateChooser name="endDate" format="dd-MM-yyyy" value="${new Date()}" />
                                            </g:jasperReport>
                                            <br />
                                            <g:jasperReport controller="report"
                                                                            action="templatePortrait"
                                                                            jasper="templatePortrait"
                                                                            name="Template (Portrait)"
                                                                            format="PDF, XLS"/>
                                            <br />
                                            <g:jasperReport controller="report"
                                                                            action="templateLandscape"
                                                                            jasper="templateLandscape"
                                                                            name="Template (Landscape)"
                                                                            format="PDF, XLS"/>
                                            <br />
                                        </td>
                                    </tr>

                                </tbody>
                            </table>
                        </div> <!--End dialog-->
                    </richui:tabContent>
<!-- End Reports tab  -->

<!-- Options tab -->
                    <richui:tabContent>
                        <br />
                        <br />
                        <div class="dialog">
                            <table>
                                <tbody>

                                    <tr class="prop">
                                        <td valign="top" class="name">
                                            <label>Change:</label>
                                        </td>
                                        <td valign="top" class="value">
                                            <a href="${createLink(action:'changePassword')}"> Password</a>
                                            <br />
                                            <a href="${createLink(action:'changeSessionTimeout')}">Session Timeout</a>
                                        </td>
                                    </tr>

                                </tbody>
                            </table>
                        </div> <!--End dialog-->
                    </richui:tabContent>
<!-- End Options tab -->

<!-- About tab -->
                    <richui:tabContent>
                        <g:render template="/about" />
                    </richui:tabContent>
<!-- End About tab -->

                </richui:tabContents>
            </richui:tabView>

        </div> <!--End body-->
    </body>
</html>
