<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>Task Search</title>
        <filterpane:includes />
        <nav:resources override="true"/>
        <resource:calendarMonthView />
    </head>
    <body>
        <div class="nav">
            <nav:renderSubItems group="nav"/>
        </div>

        <div class="body">
            <g:if test="${params.message}">
                <div class="message">${params.message}</div>
            </g:if>
            <g:render template="/shared/messages" />
            <g:hasErrors bean="${appCore}">
                <div class="errors">
                    <g:renderErrors bean="${appCore}" as="list" />
                </div>
            </g:hasErrors>
            <filterpane:currentCriteria domainBean="Task"
                                    action="searchCalendar"
                                    dateFormat="EEE, dd-MMM-yyyy"
                                    removeImgDir="images" 
                                    removeImgFile="bullet_delete.png"
                                    title="Advanced Search"/>


            <div class="paginateButtons">
                <span class="searchButtons">
                    <a href='' onclick="showElement('searchPane'); return false;">Quick</a>
                </span>
                Results: ${taskInstanceList.size()} / ${taskInstanceTotal}
                <span class="searchButtons">
                    <filterpane:filterButton text="Advanced" appliedText="Advanced" />
                </span>
            </div>
            <g:if test="${taskInstanceList.size() > 0}">
                <richui:calendarMonthView items="${taskInstanceList}"
                                                                        createLink="true"
                                                                        constraintDateFields="['targetStartDate']"
                                                                        month="${new Date()}"
                                                                        controller="taskDetailed"
                                                                        action="show"
                                                                        dayAction="create"/>
            </g:if>

            <filterpane:filterPane domainBean="Task"
                                    title="Advanced Search"
                                    action="searchCalendar"
                                    class="overlayPane"
                                    additionalProperties="id"
                                    excludeProperties="trash, comment, targetCompletionDate"
                                    associatedProperties="leadPerson.lastName, taskPriority.name"
                                    filterPropertyValues="${['taskPriority.name':[values:TaskPriority.list()],
                                                                                'leadPerson.lastName':[values:Person.executeQuery('select t.lastName from Person t')],
                                                                                targetStartDate:[years:2020..2000,precision:'day']]}"/>

        </div> <!-- end body div -->

        <!-- Start Search Pane -->
        <div class="overlayPane" id="searchPane" style="display:none;">
            <h2>Quick Search</h2>
            <g:form method="post" id="searchForm" name="searchForm" >
                <table>
                    <tbody>

                        <tr class="prop">
                            <td valign="top" class="name">
                                <label>My Tasks:</label>
                            </td>
                            <td valign="top" class="value">
                                <g:link controller="taskDetailed"
                                                action="searchCalendar"
                                                params="[quickSearch: 'searchMyTodays']">
                                                Today's
                                </g:link>
                                <br />
                                <g:link controller="taskDetailed" 
                                                action="searchCalendar"
                                                params="[quickSearch: 'searchMyInTheLastWeek']">
                                                In the last week
                                </g:link>
                            </td>
                        </tr>

                        <tr class="prop">
                            <td valign="top" class="name">
                                <label>Tasks:</label>
                            </td>
                            <td valign="top" class="value">
                                <g:link controller="taskDetailed"
                                                action="searchCalendar"
                                                params="[quickSearch: 'searchTodays']">
                                                Today's
                                </g:link>
                                <br />
                                <g:link controller="taskDetailed" 
                                                action="searchCalendar"
                                                params="[quickSearch: 'searchInTheLastWeek']">
                                                In the last week
                                </g:link>
                            </td>
                        </tr>

                    </tbody>
                </table>
                <div class="buttons">
                    <span class="button">
                        <input type="button" value="${g.message(code:'fp.tag.filterPane.button.cancel.text', default:'Cancel')}" onclick="return hideElement('searchPane');" />
                    </span>
                </div>
            </g:form>
        </div> <!-- end search pane -->

    </body>
</html>
