class Site {

    String name
    String description = ""
    String comment = ""
    Boolean isActive = true

    static hasMany = [sections: Section,
                                siteExtendedAttributes: SiteExtendedAttribute,
                                inventoryStores: InventoryStore,
                                addresses: Address]

//     static belongsTo = []

    static constraints = {
        name(maxSize:50, unique:true, blank:false)
        description(maxSize:75)
        comment(maxSize:500)
        isActive()
    }

    String toString() {
        "${this.name}"
    }
}
