
function showAssetTreePane(paneDivId, loadingImg, url) {
    Effect.Appear(paneDivId,{duration:0.4});
    new Effect.Pulsate($(loadingImg), { pulses: 200, duration: 133 });
    new Ajax.Updater({ success: paneDivId }, url, {asynchronous:true,evalScripts:true});
}

function hideAssetTreePane(paneDivId, tableDivId, saveUrl) {

    // Collect the visible div's first.
    var visibleDivs = $(tableDivId).select('div').findAll(function(el) { return el.visible(); })
    var params = "assetTreeVisibleBranches=";

    // Hide the pane.
    $(paneDivId).toggle();

    // Add the id of each visible div to params.
    visibleDivs.each(function(it) {
        params += it.identify();
        params += ","
    });

    // Remove the trailing comma.
    params = params.slice(0,params.length-1);

    // Post the id's of all visible divs.
    // asynchronous: false is against the prototype recommendations but appears to be needed in this case.
    new Ajax.Request(saveUrl, {parameters: params, asynchronous: false});
}

function toggleBranch(divId, imageId, openImgUrl, closedImgUrl) {

    $(divId).toggle();

    if( $(divId).visible() ) {
        $(imageId).src= openImgUrl;
    }
    else {
        $(imageId).src= closedImgUrl;
    }

}