import org.codehaus.groovy.grails.plugins.springsecurity.Secured

class AssignedPersonDetailedController extends BaseController {

    def assignedPersonService

    def index = {
        flash.message = g.message(code: "assignedPerson.task.not.found")
        redirect(controller:"taskDetailed", action:"search")
    }

    // the delete, save and update actions only accept POST requests
    static allowedMethods = [delete:'POST', save:'POST', update:'POST']

    def list = {
            def result = assignedPersonService.list(params)
            if(!result.error) {
                return [ assignedPersonInstanceList: result.assignedPersonInstanceList,
                                assignedPersonInstanceTotal: result.assignedPersonInstanceTotal ]
            }

            flash.message = g.message(code: result.error.code, args: result.error.args)
            redirect( controller: "appCore", action: "start" )
    }

    def show = {
        def result = assignedPersonService.show(params)

        if(!result.error)
            return [ assignedPersonInstance: result.assignedPersonInstance ]

        flash.message = g.message(code: result.error.code, args: result.error.args)

        if(params.task?.id)
            redirect(controller:"taskDetailed", action:"show", id: params.task.id)

        redirect(controller:"taskDetailed", action:"search")
    }

    def delete = {
        def result = assignedPersonService.delete(params)

        if(!result.error) {
            flash.message = g.message(code: "default.delete.success", args: ["AssignedPerson", params.id])
            redirect(controller:"taskDetailed", action:"show", id: params.task?.id)
            return
        }

        flash.message = g.message(code: result.error.code, args: result.error.args)

        if(result.error.code == "default.not.found") {
            redirect(controller:"taskDetailed", action:"show", id: params.task?.id)
            return
        }

        redirect(action:show, id: params.id)
    }

    def edit = {
        def result = assignedPersonService.edit(params)

        if(!result.error)
            return [ assignedPersonInstance : result.assignedPersonInstance ]

        flash.message = g.message(code: result.error.code, args: result.error.args)

        redirect(controller:"taskDetailed", action:"show", id: params.task?.id)

    }

    def update = {
        def result = assignedPersonService.update(params)

        if(!result.error) {
            flash.message = g.message(code: "default.update.success", args: ["AssignedPerson", params.id])
            redirect(action:show, id: params.id)
            return
        }

        if(result.error.code == "default.not.found") {
            flash.message = g.message(code: result.error.code, args: result.error.args)
            redirect(controller:"taskDetailed", action:"show", id: params.task?.id)
            return
        }

        render(view:'edit', model:[assignedPersonInstance: result.assignedPersonInstance.attach()])
    }

    def create = {
        def result = assignedPersonService.create(params)

        if(!result.error)
            return [assignedPersonInstance: result.assignedPersonInstance]

        if(result.error.code == "assignedPerson.task.not.found") {
            flash.message = g.message(code: result.error.code, args: result.error.args)
            redirect(controller: "taskDetailed", action: "search")
            return
        }

        flash.message = g.message(code: result.error.code, args: result.error.args)
        redirect(controller:"taskDetailed", action:"show", id: params.task?.id)
    }

    def save = {
        def result = assignedPersonService.save(params)

        if(!result.error) {
            flash.message = g.message(code: "default.create.success", args: ["AssignedPerson", result.assignedPersonInstance.id])
            redirect(controller:"taskDetailed", action:"show", id: result.assignedPersonInstance.task.id)
            return
        }

        render(view:'edit', model:[assignedPersonInstance: result.assignedPersonInstance])
    }

}
