class AssignedPersonService {
    boolean transactional = false

    def list(params) {
        def result = [:]
        def fail = { Map m ->
            result.error = [ code: m.code, args: ["AssignedPerson"] ]
            return result
        }

        params.max = Math.min( params.max ? params.max.toInteger() : 10,  100)
        result.assignedPersonInstanceList = AssignedPerson.list(params)
        result.assignedPersonInstanceTotal = AssignedPerson.count()

        if(!result.assignedPersonInstanceList || !result.assignedPersonInstanceTotal)
            return fail(code:"default.list.failure")

        // Success.
        return result
    }

    def show(params) {
        def result = [:]
        def fail = { Map m ->
            result.error = [ code: m.code, args: ["AssignedPerson", params.id] ]
            return result
        }

        result.assignedPersonInstance = AssignedPerson.get(params.id)

        if(!result.assignedPersonInstance)
            return fail(code:"default.not.found")

        // Success.
        return result
    }

    def delete(params) {
        def result = [:]
        def fail = { Map m ->
            result.error = [ code: m.code, args: ["AssignedPerson", params.id] ]
            return result
        }

        result.assignedPersonInstance = AssignedPerson.get(params.id)

        if(!result.assignedPersonInstance)
            return fail(code:"default.not.found")

        try {
            result.assignedPersonInstance.delete(flush:true)
            return result //Success.
        }
        catch(org.springframework.dao.DataIntegrityViolationException e) {
            return fail(code:"default.delete.failure")
        }

    }

    def edit(params) {
        def result = [:]
        def fail = { Map m ->
            result.error = [ code: m.code, args: ["AssignedPerson", params.id] ]
            return result
        }

        result.assignedPersonInstance = AssignedPerson.get(params.id)

        if(!result.assignedPersonInstance)
            return fail(code:"default.not.found")

        // Success.
        return result
    }

    def update(params) {
        AssignedPerson.withTransaction { status ->
            def result = [:]

            def fail = { Map m ->
                status.setRollbackOnly()
                if(result.assignedPersonInstance && m.field)
                    result.assignedPersonInstance.errors.rejectValue(m.field, m.code)
                result.error = [ code: m.code, args: ["AssignedPerson", params.id] ]
                return result
            }

            result.assignedPersonInstance = AssignedPerson.get(params.id)

            if(!result.assignedPersonInstance)
                return fail(code:"default.not.found")

            // Optimistic locking check.
            if(params.version) {
                if(result.assignedPersonInstance.version > params.version.toLong())
                    return fail(field:"version", code:"default.optimistic.locking.failure")
            }

            result.assignedPersonInstance.properties = params

            if(result.assignedPersonInstance.hasErrors() || !result.assignedPersonInstance.save())
                return fail(code:"default.update.failure")

            // Success.
            return result

        } //end withTransaction
    }  // end update()

    def create(params) {
        def result = [:]
        def fail = { Map m ->
            result.error = [ code: m.code, args: ["AssignedPerson", params.id] ]
            return result
        }

        if(!params.task?.id)
            fail(code:"assignedPerson.task.not.found")

        result.assignedPersonInstance = new AssignedPerson()
        result.assignedPersonInstance.properties = params

        // success
        return result
    }

    def save(params) {
        def result = [:]
        def fail = { Map m ->
            if(result.assignedPersonInstance && m.field)
                result.assignedPersonInstance.errors.rejectValue(m.field, m.code)
            result.error = [ code: m.code, args: ["AssignedPerson", params.id] ]
            return result
        }

        result.assignedPersonInstance = new AssignedPerson(params)

        if(result.assignedPersonInstance.hasErrors() || !result.assignedPersonInstance.save(flush: true))
            return fail(code:"default.create.failure")

        // success
        return result
    }

} // end class