

<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>Create Assigned Group</title>
    </head>
    <body>
        <div class="nav">
            <h1>Create Assigned Group</h1>
        </div>
        <div class="body">
            <g:if test="${flash.message}">
            <div class="message">${flash.message}</div>
            </g:if>
            <g:hasErrors bean="${assignedGroupInstance}">
            <div class="errors">
                <g:renderErrors bean="${assignedGroupInstance}" as="list" />
            </div>
            </g:hasErrors>
            <g:form action="save" method="post" >
                <input type="hidden"  name="task.id" value="${assignedGroupInstance?.task?.id}" />
                <div class="dialog">
                    <table>
                        <tbody>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="task">Task:</label>
                                </td>
                                <td valign="top" class="name">
                                    <g:link controller="taskDetailed" action="show" id="${assignedGroupInstance.task.id}" >
                                        ${assignedGroupInstance?.task.encodeAsHTML()}
                                    </g:link>
                                </td>
                            </tr>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="personGroup">Group:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:assignedGroupInstance,field:'personGroup','errors')}">
                                    <g:select optionKey="id" from="${PersonGroup.list()}" name="personGroup.id" value="${assignedGroupInstance?.personGroup?.id}" ></g:select>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="durationHour">Estimated Duration:</label>
                                </td>

                                <td valign="top" class="value">
                                    <input class="time ${hasErrors(bean:assignedGroupInstance,field:'estimatedHour','errors')}"
                                        type="text" id="estimatedHour" name="estimatedHour" 
                                        value="${fieldValue(bean:assignedGroupInstance,field:'estimatedHour')}" />
                                    :
                                    <input class="time ${hasErrors(bean:assignedGroupInstance,field:'estimatedMinute','errors')}"
                                        type="text" id="estimatedMinute" name="estimatedMinute" 
                                        value="${fieldValue(bean:assignedGroupInstance,field:'estimatedMinute')}" />
                                    <g:helpBalloon code="assignedGroup.estimatedDuration" />
                                </td> 
                            </tr>
                        
                        </tbody>
                    </table>
                </div>
                <div class="buttons">
                    <span class="button"><input class="save" type="submit" value="Create" /></span>
                </div>
            </g:form>
        </div>
    </body>
</html>
