/* Provides a service class with some methods that integrate the Person domain class and Acegi security.
 *
 */
class PersonService {

    boolean transactional = false

    def authenticateService

    // Get current user as a Person and in a safe way to avoid a null userDomain during bootstrap.
    def currentUser() {
        if(authenticateService.userDomain()) {
            return Person.get(authenticateService.userDomain().id)
        }
        else {
            //println "Warning: userDomain not active yet, attempting to return Person #1"
            return Person.get(1)
        }
    }

    // Convenience wrapper.
    def encodePassword(passClearText) {
        authenticateService.encodePassword(passClearText)
    }

}
