import org.codehaus.groovy.grails.plugins.springsecurity.Secured

class InventoryStoreController extends BaseAppAdminController {
    
    def index = { redirect(action:list,params:params) }

    // the delete, save and update actions only accept POST requests
    static allowedMethods = [delete:'POST', save:'POST', update:'POST']

    def list = {
        params.max = Math.min( params.max ? params.max.toInteger() : 10,  100)
        [ inventoryStoreInstanceList: InventoryStore.list( params ), inventoryStoreInstanceTotal: InventoryStore.count() ]
    }

    def show = {
        def inventoryStoreInstance = InventoryStore.get( params.id )

        if(!inventoryStoreInstance) {
            flash.message = "InventoryStore not found with id ${params.id}"
            redirect(action:list)
        }
        else { return [ inventoryStoreInstance : inventoryStoreInstance ] }
    }

    def delete = {
        def inventoryStoreInstance = InventoryStore.get( params.id )
        if(inventoryStoreInstance) {
            try {
                inventoryStoreInstance.delete(flush:true)
                flash.message = "InventoryStore ${params.id} deleted"
                redirect(action:list)
            }
            catch(org.springframework.dao.DataIntegrityViolationException e) {
                flash.message = "InventoryStore ${params.id} could not be deleted"
                redirect(action:show,id:params.id)
            }
        }
        else {
            flash.message = "InventoryStore not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def edit = {
        def inventoryStoreInstance = InventoryStore.get( params.id )

        if(!inventoryStoreInstance) {
            flash.message = "InventoryStore not found with id ${params.id}"
            redirect(action:list)
        }
        else {
            return [ inventoryStoreInstance : inventoryStoreInstance ]
        }
    }

    def update = {
        def inventoryStoreInstance = InventoryStore.get( params.id )
        if(inventoryStoreInstance) {
            if(params.version) {
                def version = params.version.toLong()
                if(inventoryStoreInstance.version > version) {
                    
                    inventoryStoreInstance.errors.rejectValue("version", "inventoryStore.optimistic.locking.failure", "Another user has updated this InventoryStore while you were editing.")
                    render(view:'edit',model:[inventoryStoreInstance:inventoryStoreInstance])
                    return
                }
            }
            inventoryStoreInstance.properties = params
            if(!inventoryStoreInstance.hasErrors() && inventoryStoreInstance.save()) {
                flash.message = "InventoryStore ${params.id} updated"
                redirect(action:show,id:inventoryStoreInstance.id)
            }
            else {
                render(view:'edit',model:[inventoryStoreInstance:inventoryStoreInstance])
            }
        }
        else {
            flash.message = "InventoryStore not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def create = {
        def inventoryStoreInstance = new InventoryStore()
        inventoryStoreInstance.properties = params
        return ['inventoryStoreInstance':inventoryStoreInstance]
    }

    def save = {
        def inventoryStoreInstance = new InventoryStore(params)
        if(!inventoryStoreInstance.hasErrors() && inventoryStoreInstance.save()) {
            flash.message = "InventoryStore ${inventoryStoreInstance.id} created"
            redirect(action:show,id:inventoryStoreInstance.id)
        }
        else {
            render(view:'create',model:[inventoryStoreInstance:inventoryStoreInstance])
        }
    }
}
