

<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>Edit StoreLocation</title>
    </head>
    <body>
        <div class="nav">
            <span class="menuButton"><a class="home" href="${resource(dir:'')}">Home</a></span>
            <span class="menuButton"><g:link class="list" action="list">StoreLocation List</g:link></span>
            <span class="menuButton"><g:link class="create" action="create">New StoreLocation</g:link></span>
        </div>
        <div class="body">
            <h1>Edit StoreLocation</h1>
            <g:if test="${flash.message}">
            <div class="message">${flash.message}</div>
            </g:if>
            <g:hasErrors bean="${storeLocationInstance}">
            <div class="errors">
                <g:renderErrors bean="${storeLocationInstance}" as="list" />
            </div>
            </g:hasErrors>
            <g:form method="post" >
                <input type="hidden" name="id" value="${storeLocationInstance?.id}" />
                <input type="hidden" name="version" value="${storeLocationInstance?.version}" />
                <div class="dialog">
                    <table>
                        <tbody>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="bin">Bin:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:storeLocationInstance,field:'bin','errors')}">
                                    <input type="text" maxlength="50" id="bin" name="bin" value="${fieldValue(bean:storeLocationInstance,field:'bin')}"/>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="inventoryStore">Inventory Store:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:storeLocationInstance,field:'inventoryStore','errors')}">
                                    <g:select optionKey="id" from="${InventoryStore.list()}" name="inventoryStore.id" value="${storeLocationInstance?.inventoryStore?.id}" ></g:select>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="isActive">Is Active:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:storeLocationInstance,field:'isActive','errors')}">
                                    <g:checkBox name="isActive" value="${storeLocationInstance?.isActive}" ></g:checkBox>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="storedItems">Stored Items:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:storeLocationInstance,field:'storedItems','errors')}">
                                    
<ul>
<g:each var="s" in="${storeLocationInstance?.storedItems?}">
    <li><g:link controller="storedItemDetailed" action="show" id="${s.id}">${s?.encodeAsHTML()}</g:link></li>
</g:each>
</ul>
<g:link controller="storedItemDetailed" params="['storeLocation.id':storeLocationInstance?.id]" action="create">Add StoredItem</g:link>

                                </td>
                            </tr> 
                        
                        </tbody>
                    </table>
                </div>
                <div class="buttons">
                    <span class="button"><g:actionSubmit class="save" value="Update" /></span>
                    <span class="button"><g:actionSubmit class="delete" onclick="return confirm('Are you sure?');" value="Delete" /></span>
                </div>
            </g:form>
        </div>
    </body>
</html>
