import org.codehaus.groovy.grails.plugins.springsecurity.Secured

class PlannedMaintenanceDetailedController extends BaseController {
    
    def index = { redirect(action:list,params:params) }

    // the delete, save and update actions only accept POST requests
    static allowedMethods = [delete:'POST', save:'POST', update:'POST']

    def list = {
        params.max = Math.min( params.max ? params.max.toInteger() : 10,  100)
        [ plannedMaintenanceInstanceList: PlannedMaintenance.list( params ), plannedMaintenanceInstanceTotal: PlannedMaintenance.count() ]
    }

    def show = {
// Use this to return a list of the maintenanceActions
//     def list = {
//         params.max = Math.min( params.max ? params.max.toInteger() : 10,  100)
//         [ maintenanceActionInstanceList: MaintenanceAction.list( params ), maintenanceActionInstanceTotal: MaintenanceAction.count() ]
//     }
        def plannedMaintenanceInstance = PlannedMaintenance.get( params.id )

        if(!plannedMaintenanceInstance) {
            flash.message = "PlannedMaintenance not found with id ${params.id}"
            redirect(action:list)
        }
        else { return [ plannedMaintenanceInstance : plannedMaintenanceInstance ] }
    }

    def delete = {
        def plannedMaintenanceInstance = PlannedMaintenance.get( params.id )
        if(plannedMaintenanceInstance) {
            try {
                plannedMaintenanceInstance.delete()
                flash.message = "PlannedMaintenance ${params.id} deleted"
                redirect(action:list)
            }
            catch(org.springframework.dao.DataIntegrityViolationException e) {
                flash.message = "PlannedMaintenance ${params.id} could not be deleted"
                redirect(action:show,id:params.id)
            }
        }
        else {
            flash.message = "PlannedMaintenance not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def edit = {
        def plannedMaintenanceInstance = PlannedMaintenance.get( params.id )

        if(!plannedMaintenanceInstance) {
            flash.message = "PlannedMaintenance not found with id ${params.id}"
            redirect(action:list)
        }
        else {
            return [ plannedMaintenanceInstance : plannedMaintenanceInstance ]
        }
    }

    def update = {
        def plannedMaintenanceInstance = PlannedMaintenance.get( params.id )
        if(plannedMaintenanceInstance) {
            if(params.version) {
                def version = params.version.toLong()
                if(plannedMaintenanceInstance.version > version) {
                    
                    plannedMaintenanceInstance.errors.rejectValue("version", "plannedMaintenance.optimistic.locking.failure", "Another user has updated this PlannedMaintenance while you were editing.")
                    render(view:'edit',model:[plannedMaintenanceInstance:plannedMaintenanceInstance])
                    return
                }
            }
            plannedMaintenanceInstance.properties = params
            if(!plannedMaintenanceInstance.hasErrors() && plannedMaintenanceInstance.save()) {
                flash.message = "PlannedMaintenance ${params.id} updated"
                redirect(action:show,id:plannedMaintenanceInstance.id)
            }
            else {
                render(view:'edit',model:[plannedMaintenanceInstance:plannedMaintenanceInstance])
            }
        }
        else {
            flash.message = "PlannedMaintenance not found with id ${params.id}"
            redirect(action:edit,id:params.id)
        }
    }

    def create = {
        def plannedMaintenanceInstance = new PlannedMaintenance()
        plannedMaintenanceInstance.properties = params
        return ['plannedMaintenanceInstance':plannedMaintenanceInstance]
    }

    def save = {
        def plannedMaintenanceInstance = new PlannedMaintenance(params)
        if(!plannedMaintenanceInstance.hasErrors() && plannedMaintenanceInstance.save()) {
            flash.message = "PlannedMaintenance ${plannedMaintenanceInstance.id} created"
            redirect(action:show,id:plannedMaintenanceInstance.id)
        }
        else {
            render(view:'create',model:[plannedMaintenanceInstance:plannedMaintenanceInstance])
        }
    }
}
