import grails.util.GrailsUtil

class BootStrap 
{
    //Required to be right here for Acegi plugin.
    def authenticateService
    Boolean BootStrapDemoDataSuccessful = true

    def init = { servletContext ->

    println "**** BootStrap GrailsUtil.environment = ${GrailsUtil.environment}"
    
        switch (GrailsUtil.environment)
        {
            case "development":
                        bootStrapDemoData()
                        break
            case "test":
                        break
            case "production":
                        bootStrapDemoData()
                        break 
        }
    
    }

    def destroy = {
    }

    //Insert some demo/startup data.
    void bootStrapDemoData()
    {
        println "BootStrapping demo data..."

/*******************
START OF TASK

*******************/

//TypeOfPersonGroup
	def personGroupTypeInstance
        personGroupTypeInstance = new PersonGroupType(name:"Department")
	BootStrapSaveAndTest(personGroupTypeInstance)
        personGroupTypeInstance = new PersonGroupType(name:"Contractor")
	BootStrapSaveAndTest(personGroupTypeInstance)
        personGroupTypeInstance = new PersonGroupType(name:"ProjectTeam")
	BootStrapSaveAndTest(personGroupTypeInstance)
    
//PersonGroup
	def personGroupInstance
        personGroupInstance = new PersonGroup(personGroupType:PersonGroupType.findByName("Department"),
                        name:"Electrical")
	BootStrapSaveAndTest(personGroupInstance)
        personGroupInstance = new PersonGroup(personGroupType:PersonGroupType.findByName("Department"),
                        name:"Mechanical")
	BootStrapSaveAndTest(personGroupInstance)
        personGroupInstance = new PersonGroup(personGroupType:PersonGroupType.findByName("Department"),
                        name:"Production")
	BootStrapSaveAndTest(personGroupInstance)
        personGroupInstance = new PersonGroup(personGroupType:PersonGroupType.get(2),
                        name:"Kewl AirCon Guys")
	BootStrapSaveAndTest(personGroupInstance)
        personGroupInstance = new PersonGroup(personGroupType:PersonGroupType.get(3),
                        name:"gnuMims")
	BootStrapSaveAndTest(personGroupInstance)

//Authority
        def authInstance

        authInstance = new Authority(description:"Application Admin, not required for daily use! Grants full admin access to the application.",
                                        authority:"ROLE_AppAdmin")
        BootStrapSaveAndTest(authInstance)

        authInstance = new Authority(description:"Business manager, grants full management access.",
                                        authority:"ROLE_Manager")
        BootStrapSaveAndTest(authInstance)

        authInstance = new Authority(description:"Application User, all application users need this base role to allow login.",
                                        authority:"ROLE_AppUser")
        BootStrapSaveAndTest(authInstance)
            
//Person
        def passClearText = "pass"
        def passwordEncoded = authenticateService.encodePassword(passClearText)
        def personInstance

        //Person #1
        personInstance = new Person(loginName:"admin",
                                    firstName:"Admin",
                                    lastName:"Powers",
                                    pass:passClearText,
                                    password:passwordEncoded,
                                    email:"admin@example.com")
        BootStrapSaveAndTest(personInstance)
        personInstance.addToAuthorities(Authority.get(1))
        personInstance.addToAuthorities(Authority.get(2))
        personInstance.addToAuthorities(Authority.get(3))
        personInstance.addToPersonGroups(PersonGroup.findByName("gnuMims"))

        //Person #2
        personInstance = new Person(loginName:"manager",
                                    firstName:"Meca",
                                    lastName:"Manager",
                                    pass:passClearText,
                                    password:passwordEncoded,
                                    email:"manager@example.com")
        BootStrapSaveAndTest(personInstance)
        personInstance.addToAuthorities(Authority.get(2))
        personInstance.addToAuthorities(Authority.get(3))
        personInstance.addToPersonGroups(PersonGroup.findByName("gnuMims"))

        //Person #3
        personInstance = new Person(loginName:"user",
                                    firstName:"Demo",
                                    lastName:"User",
                                    pass:passClearText,
                                    password:passwordEncoded,
                                    email:"user@example.com")
        BootStrapSaveAndTest(personInstance)
        personInstance.addToAuthorities(Authority.get(3))
        personInstance.addToPersonGroups(PersonGroup.findByName("Electrical"))

        //Person #4
        personInstance = new Person(loginName:"craig",
                                    firstName:"Craig",
                                    lastName:"SuperSparky",
                                    pass:passClearText,
                                    password:passwordEncoded,
                                    email:"user@example.com")
        BootStrapSaveAndTest(personInstance)
        personInstance.addToAuthorities(Authority.get(3))
        personInstance.addToPersonGroups(PersonGroup.findByName("Electrical"))

        //Person #5
        personInstance = new Person(loginName:"john",
                                    firstName:"John",
                                    lastName:"SuperFitter",
                                    pass:passClearText,
                                    password:passwordEncoded,
                                    email:"user@example.com")
        BootStrapSaveAndTest(personInstance)
        personInstance.addToAuthorities(Authority.get(3))
        personInstance.addToPersonGroups(PersonGroup.findByName("Mechanical"))

        //Person #6
        personInstance = new Person(loginName:"mann",
                                    firstName:"Production",
                                    lastName:"Mann",
                                    pass:passClearText,
                                    password:passwordEncoded,
                                    email:"user@example.com")
        BootStrapSaveAndTest(personInstance)
        personInstance.addToAuthorities(Authority.get(3))
        personInstance.addToPersonGroups(PersonGroup.findByName("Production"))

//TaskGroup
        def taskGroupInstance

        taskGroupInstance = new TaskGroup(name:"Engineering Activites",
                      description:"Engineering daily activities")
        BootStrapSaveAndTest(taskGroupInstance)

        taskGroupInstance = new TaskGroup(name:"Production Activites",
                      description:"Production daily activities")
        BootStrapSaveAndTest(taskGroupInstance)

        taskGroupInstance = new TaskGroup(name:"New Projects",
                      description:" ")
        BootStrapSaveAndTest(taskGroupInstance)

//TaskStatus
        def taskStatusInstance
    
        taskStatusInstance = new TaskStatus(name:"Not Started")
        BootStrapSaveAndTest(taskStatusInstance)

        taskStatusInstance = new TaskStatus(name:"In Progress")
        BootStrapSaveAndTest(taskStatusInstance)

        taskStatusInstance = new TaskStatus(name:"Completed")
        BootStrapSaveAndTest(taskStatusInstance)

//TaskPriority
        def taskPriorityInstance

        taskPriorityInstance = new TaskPriority(name:"Low")
        BootStrapSaveAndTest(taskPriorityInstance)

        taskPriorityInstance = new TaskPriority(name:"Normal")
        BootStrapSaveAndTest(taskPriorityInstance)

        taskPriorityInstance = new TaskPriority(name:"High")
        BootStrapSaveAndTest(taskPriorityInstance)

        taskPriorityInstance = new TaskPriority(name:"Immediate")
        BootStrapSaveAndTest(taskPriorityInstance)

//TaskType
        def taskTypeInstance

        taskTypeInstance = new TaskType(name:"Unscheduled Breakin")
        BootStrapSaveAndTest(taskTypeInstance)

        taskTypeInstance = new TaskType(name:"Planned Maintenance")
        BootStrapSaveAndTest(taskTypeInstance)

        taskTypeInstance = new TaskType(name:"Project")
        BootStrapSaveAndTest(taskTypeInstance)

        taskTypeInstance = new TaskType(name:"Turnaround")
        BootStrapSaveAndTest(taskTypeInstance)

        taskTypeInstance = new TaskType(name:"Production Run")
        BootStrapSaveAndTest(taskTypeInstance)

//Task
        def taskInstance

        //Task #1
        taskInstance = new Task(taskGroup:TaskGroup.findByName("Engineering Activites"),
                 taskStatus:TaskStatus.findByName("Not Started"),
                 taskPriority:TaskPriority.get(2),
                 taskType:TaskType.get(1),
                 leadPerson:Person.get(3),
                 description:"Check specific level sensor",
                 comment:"Has been noted as problematic, try recallibrating")
        BootStrapSaveAndTest(taskInstance)

        //Task #2
        taskInstance = new Task(taskGroup:TaskGroup.findByName("Engineering Activites"),
                taskStatus:TaskStatus.findByName("Not Started"),
                taskPriority:TaskPriority.get(2),
                taskType:TaskType.get(1),
                leadPerson:Person.get(5),
                description:"Some follow-up work",
                comment:"Some help required",
                parentTask: Task.get(1))
        BootStrapSaveAndTest(taskInstance)

        //Task #3
        taskInstance = new Task(taskGroup:TaskGroup.findByName("Engineering Activites"),
                taskStatus:TaskStatus.findByName("Not Started"),
                taskPriority:TaskPriority.get(2),
                taskType:TaskType.get(1),
                leadPerson:Person.get(5),
                description:"A Sub Task can be created by setting the Parent Task value",
                comment:"Some help required",
                parentTask: Task.get(1))
        BootStrapSaveAndTest(taskInstance)

        //Task #4
        taskInstance = new Task(taskGroup:TaskGroup.findByName("Engineering Activites"),
                 taskStatus:TaskStatus.findByName("Not Started"),
                 taskPriority:TaskPriority.get(2),
                 taskType:TaskType.get(1),
                 leadPerson:Person.get(4),
                 description:"Replace sensor at next opportunity.",
                 comment:"Nothing else has worked.",
                parentTask: Task.get(1))
        BootStrapSaveAndTest(taskInstance)

        //Task #5
        taskInstance = new Task(taskGroup:TaskGroup.findByName("Production Activites"),
                 taskStatus:TaskStatus.findByName("Not Started"),
                 taskPriority:TaskPriority.get(2),
                 taskType:TaskType.get(5),
                 leadPerson:Person.get(6),
                 description:"Production Report",
                 comment:"Production report for specific production run or shift")
        BootStrapSaveAndTest(taskInstance)

        //Task #6
        taskInstance = new Task(taskGroup:TaskGroup.findByName("New Projects"),
                 taskStatus:TaskStatus.findByName("Not Started"),
                 taskPriority:TaskPriority.get(2),
                 taskType:TaskType.get(3),
                 leadPerson:Person.get(1),
                 description:"Make killer CMMS app",
                 comment:"Use Grails and get a move on!")
        BootStrapSaveAndTest(taskInstance)

//EntryType
        def entryTypeInstance

        entryTypeInstance = new EntryType(name:"Fault")
        BootStrapSaveAndTest(entryTypeInstance)

        entryTypeInstance = new EntryType(name:"WorkDone")
        BootStrapSaveAndTest(entryTypeInstance)

        entryTypeInstance = new EntryType(name:"Production Note")
        BootStrapSaveAndTest(entryTypeInstance)

        entryTypeInstance = new EntryType(name:"Work Request")
        BootStrapSaveAndTest(entryTypeInstance)

//Entry
        def entryInstance

        //Entry #1
        entryInstance = new Entry(enteredBy: Person.get(6),
                                                    task: Task.get(1),
                                                    entryType: EntryType.findByName("Fault"),
                                                    comment: "This level sensor is causing us trouble.",
                                                    durationMinute: 20)
        BootStrapSaveAndTest(entryInstance)

        //Entry #2
        entryInstance = new Entry(enteredBy: Person.get(4),
                                                    task: Task.get(1),
                                                    entryType: EntryType.findByName("WorkDone"),
                                                    comment: "Cleaned sensor, see how it goes.",
                                                    durationMinute: 30)
        BootStrapSaveAndTest(entryInstance)

        //Entry #3
        entryInstance = new Entry(enteredBy: Person.get(4),
                                                    task: Task.get(1),
                                                    entryType: EntryType.findByName("WorkDone"),
                                                    comment: "Checked up on it later and sensor is dropping out intermittently, created subTask to replace sensor.",
                                                    durationMinute: 20)
        BootStrapSaveAndTest(entryInstance)

//ModificationType
        def taskModificationTypeInstance
        taskModificationTypeInstance = new TaskModificationType(name:"Created").save()
        taskModificationTypeInstance = new TaskModificationType(name:"Completed").save()
        taskModificationTypeInstance = new TaskModificationType(name:"Closed").save()
        taskModificationTypeInstance = new TaskModificationType(name:"Altered").save()
        taskModificationTypeInstance = new TaskModificationType(name:"TargetDateModified").save()
        taskModificationTypeInstance = new TaskModificationType(name:"ScheduledDateModified").save()
        taskModificationTypeInstance = new TaskModificationType(name:"DescriptionModified").save()
        taskModificationTypeInstance = new TaskModificationType(name:"AssignedToModified").save()
        taskModificationTypeInstance = new TaskModificationType(name:"NameModified").save()
    
//AssignedPerson
        def assignedPersonInstance

        //AssignedPerson #1
        assignedPersonInstance = new AssignedPerson(person: Person.get(4),
                                                                                        task: Task.get(1),
                                                                                        estimatedHour: 1,
                                                                                        estimatedMinute: 20)
        BootStrapSaveAndTest(assignedPersonInstance)

        //AssignedPerson #2
        assignedPersonInstance = new AssignedPerson(person: Person.get(5),
                                                                                        task: Task.get(1),
                                                                                        estimatedHour: 3,
                                                                                        estimatedMinute: 30)
        BootStrapSaveAndTest(assignedPersonInstance)

/*******************
START OF INVENTORY

*******************/

//Site
        def siteInstance

        siteInstance = new Site(name: "Creek Mill")
        BootStrapSaveAndTest(siteInstance)

        siteInstance = new Site(name: "Jasper Street Depot")
        BootStrapSaveAndTest(siteInstance)

//InventoryStore
        def inventoryStoreInstance 

        inventoryStoreInstance = new InventoryStore(site: Site.get(1), name: "Store #1")
        BootStrapSaveAndTest(inventoryStoreInstance)

        inventoryStoreInstance = new InventoryStore(site: Site.get(2), name: "Store #2")
        BootStrapSaveAndTest(inventoryStoreInstance)

//StoreLocation
        def storeLocation
        
        storeLocation = new StoreLocation(inventoryStore: InventoryStore.get(1), bin: "A1-2")
        BootStrapSaveAndTest(storeLocation)

        storeLocation = new StoreLocation(inventoryStore: InventoryStore.get(1), bin: "C55")
        BootStrapSaveAndTest(storeLocation)

//UnitOfMeasure
        def unitOfMeasureInstance

        //UnitOfMeasure #1
        unitOfMeasureInstance = new UnitOfMeasure(name: "each")
        BootStrapSaveAndTest(unitOfMeasureInstance)

        //UnitOfMeasure #2
        unitOfMeasureInstance = new UnitOfMeasure(name: "meter(s)")
        BootStrapSaveAndTest(unitOfMeasureInstance)

        //UnitOfMeasure #3
        unitOfMeasureInstance = new UnitOfMeasure(name: "box(es)")
        BootStrapSaveAndTest(unitOfMeasureInstance)

        //UnitOfMeasure #4
        unitOfMeasureInstance = new UnitOfMeasure(name: "litre(s)")
        BootStrapSaveAndTest(unitOfMeasureInstance)

        //UnitOfMeasure #5
        unitOfMeasureInstance = new UnitOfMeasure(name: "kilogram(s)")
        BootStrapSaveAndTest(unitOfMeasureInstance)

//InventoryGroup
        def inventoryGroupInstance

        //InventoryGroup #1
        inventoryGroupInstance = new InventoryGroup(name: "Misc")
        BootStrapSaveAndTest(inventoryGroupInstance)

        //InventoryGroup #2
        inventoryGroupInstance = new InventoryGroup(name: "Electrical")
        BootStrapSaveAndTest(inventoryGroupInstance)

        //InventoryGroup #3
        inventoryGroupInstance = new InventoryGroup(name: "Mechanical")
        BootStrapSaveAndTest(inventoryGroupInstance)

        //InventoryGroup #4
        inventoryGroupInstance = new InventoryGroup(name: "Production")
        BootStrapSaveAndTest(inventoryGroupInstance)

//InventoryType
        def inventoryTypeInstance

        inventoryTypeInstance = new InventoryType(name: "Consumable")
        BootStrapSaveAndTest(inventoryTypeInstance)

        inventoryTypeInstance = new InventoryType(name: "Repairable")
        BootStrapSaveAndTest(inventoryTypeInstance)

//InventoryItem
        def inventoryItemInstance

        //InventoryItem #1
        inventoryItemInstance = new InventoryItem(inventoryGroup: InventoryGroup.get(1),
                                                                                    inventoryType: InventoryType.get(1),
                                                                                    unitOfMeasure: UnitOfMeasure.get(2),
                                                                                    name: "J-Rope",
                                                                                    description: "Twine wound J-Rope",
                                                                                    reorderPoint: 0)
        BootStrapSaveAndTest(inventoryItemInstance)

        //InventoryItem #2
        inventoryItemInstance = new InventoryItem(inventoryGroup: InventoryGroup.get(1),
                                                                                    inventoryType: InventoryType.get(1),
                                                                                    unitOfMeasure: UnitOfMeasure.get(2),
                                                                                    name: "L-Rope",
                                                                                    description: "Twine wound L-Rope",
                                                                                    alternateItems: InventoryItem.get(1),
                                                                                    reorderPoint: 0)
        BootStrapSaveAndTest(inventoryItemInstance)

        //InventoryItem #3
        inventoryItemInstance = new InventoryItem(inventoryGroup: InventoryGroup.get(3),
                                                                                    inventoryType: InventoryType.get(1),
                                                                                    unitOfMeasure: UnitOfMeasure.get(1),
                                                                                    name: "2305-2RS",
                                                                                    description: "Bearing 25x62x24mm double row self aligning ball",
                                                                                    reorderPoint: 2)
        BootStrapSaveAndTest(inventoryItemInstance)

        //InventoryItem #4
        inventoryItemInstance = new InventoryItem(inventoryGroup: InventoryGroup.get(2),
                                                                                    inventoryType: InventoryType.get(1),
                                                                                    unitOfMeasure: UnitOfMeasure.get(1),
                                                                                    name: "L1592-K10",
                                                                                    description: "10kW contactor",
                                                                                    reorderPoint: 0)
        BootStrapSaveAndTest(inventoryItemInstance)

        //InventoryItem #5
        inventoryItemInstance = new InventoryItem(inventoryGroup: InventoryGroup.get(3),
                                                                                    inventoryType: InventoryType.get(1),
                                                                                    unitOfMeasure: UnitOfMeasure.get(1),
                                                                                    name: "6205-ZZ",
                                                                                    description: "Bearing 25x52x15mm single row ball shielded",
                                                                                    reorderPoint: 2)
        BootStrapSaveAndTest(inventoryItemInstance)

//StoredItem
        def storedItemInstance

        //StoredItem #1
        storedItemInstance = new StoredItem(inventoryItem: InventoryItem.get(1),
                                                                            storeLocation: StoreLocation.get(1),
                                                                            quantity: 8)
        BootStrapSaveAndTest(storedItemInstance)

        //StoredItem #2
        storedItemInstance = new StoredItem(inventoryItem: InventoryItem.get(1),
                                                                            storeLocation: StoreLocation.get(2),
                                                                            quantity: 4)
        BootStrapSaveAndTest(storedItemInstance)

        //StoredItem #3
        storedItemInstance = new StoredItem(inventoryItem: InventoryItem.get(2),
                                                                            storeLocation: StoreLocation.get(1),
                                                                            quantity: 2)
        BootStrapSaveAndTest(storedItemInstance)

        //StoredItem #4
        storedItemInstance = new StoredItem(inventoryItem: InventoryItem.get(3),
                                                                            storeLocation: StoreLocation.get(1),
                                                                            quantity: 2)
        BootStrapSaveAndTest(storedItemInstance)

        //StoredItem #5
        storedItemInstance = new StoredItem(inventoryItem: InventoryItem.get(4),
                                                                            storeLocation: StoreLocation.get(1),
                                                                            quantity: 30)
        BootStrapSaveAndTest(storedItemInstance)

/*******************
START OF ASSET

*******************/

//Frequency
        def frequencyInstance

        //Frequency #1
        frequencyInstance = new Frequency(frequency: "Day(s)")
        BootStrapSaveAndTest(frequencyInstance)

        //Frequency #2
        frequencyInstance = new Frequency(frequency: "Week(s)")
        BootStrapSaveAndTest(frequencyInstance)

        //Frequency #3
        frequencyInstance = new Frequency(frequency: "Month(s)")
        BootStrapSaveAndTest(frequencyInstance)

        //Frequency #4
        frequencyInstance = new Frequency(frequency: "Year(s)")
        BootStrapSaveAndTest(frequencyInstance)

//LifePlan
        def lifeplanInstance

        lifeplanInstance = new LifePlan(name: "Initial Plan",
                                                                timeInHours: 1,
                                                                maintenanceAction: "Visual inspection")
        BootStrapSaveAndTest(lifeplanInstance)

//Form
        def formInstance

        formInstance = new Form(name: "Form 1")
        BootStrapSaveAndTest(formInstance)

//SystemSection
    def systemSectionInstance 

    systemSectionInstance = new SystemSection(name: "Press Section",
                                                                                   lifeplan: LifePlan.get(1))
    BootStrapSaveAndTest(systemSectionInstance)

//AssetType
        def assetTypeInstance
        assetTypeInstance = new AssetType(name: "Folder", 
                        lifeplan: LifePlan.get(1),
                        systemSection: SystemSection.get(1))
        BootStrapSaveAndTest(assetTypeInstance)

        assetTypeInstance = new AssetType(name: "Print Unit", 
                        lifeplan: LifePlan.get(1),
                        systemSection: SystemSection.get(1))
        BootStrapSaveAndTest(assetTypeInstance)
    
//Assembly
        def assemblyInstance
        assemblyInstance = new Assembly(name: "Delivery Belts",
                        lifeplan: LifePlan.get(1))
        BootStrapSaveAndTest(assemblyInstance)
    
        assemblyInstance = new Assembly(name: "Print Couple",
                        lifeplan: LifePlan.get(1))
        BootStrapSaveAndTest(assemblyInstance)

//SubAssembly
        def subAssemblyInstance
        subAssemblyInstance = new SubAssembly(name: "Centre Belt",
                        lifeplan: LifePlan.get(1))
        BootStrapSaveAndTest(subAssemblyInstance)
    
        subAssemblyInstance = new SubAssembly(name: "Form Roller",
                        lifeplan: LifePlan.get(1))
        BootStrapSaveAndTest(subAssemblyInstance)

//ComponentItem
    def componentItemInstance
    componentItemInstance = new ComponentItem(name: "Centre Pulley",
                                                                                        fmeaNumber: 1,
                                                                                       lifeplan: LifePlan.get(1))
    BootStrapSaveAndTest(componentItemInstance)

    componentItemInstance = new ComponentItem(name: "Bearing",
                                                                                        fmeaNumber: 1,
                                                                                       lifeplan: LifePlan.get(1))
    BootStrapSaveAndTest(componentItemInstance)


//Asset
        def assetInstance

        //Asset #1
        assetInstance = new Asset(name: "Print Unit 23",
                                                        lifeplan: LifePlan.get(1),
                                                        assetType: AssetType.get(1),
                                                        riskPriorityNumber: 1)
        BootStrapSaveAndTest(assetInstance)

//Finally did it all work.        
        if(BootStrapDemoDataSuccessful) {
            println "BootStrapping demo data...successful."
        }
        else println "BootStrapping demo data...failed."
    }

//Call this function instead of .save()
    void BootStrapSaveAndTest(object) {
        if(!object.save()) {
            BootStrapDemoDataSuccessful = false
            println "'${object}' failed to save!"
            println object.errors

        }
    } 
}
