

<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>Edit Assembly</title>
    </head>
    <body>
        <div class="nav">
            <span class="menuButton"><a class="home" href="${createLinkTo(dir:'')}">Home</a></span>
            <span class="menuButton"><g:link class="list" action="list">Assembly List</g:link></span>
            <span class="menuButton"><g:link class="create" action="create">New Assembly</g:link></span>
        </div>
        <div class="body">
            <h1>Edit Assembly</h1>
            <g:if test="${flash.message}">
            <div class="message">${flash.message}</div>
            </g:if>
            <g:hasErrors bean="${assemblyInstance}">
            <div class="errors">
                <g:renderErrors bean="${assemblyInstance}" as="list" />
            </div>
            </g:hasErrors>
            <g:form method="post" >
                <input type="hidden" name="id" value="${assemblyInstance?.id}" />
                <input type="hidden" name="version" value="${assemblyInstance?.version}" />
                <div class="dialog">
                    <table>
                        <tbody>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="assetTypes">Asset Types:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:assemblyInstance,field:'assetTypes','errors')}">
                                    
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="description">Description:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:assemblyInstance,field:'description','errors')}">
                                    <input type="text" id="description" name="description" value="${fieldValue(bean:assemblyInstance,field:'description')}"/>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="isActive">Is Active:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:assemblyInstance,field:'isActive','errors')}">
                                    <g:checkBox name="isActive" value="${assemblyInstance?.isActive}" ></g:checkBox>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="lifeplan">Lifeplan:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:assemblyInstance,field:'lifeplan','errors')}">
                                    <g:select optionKey="id" from="${LifePlan.list()}" name="lifeplan.id" value="${assemblyInstance?.lifeplan?.id}" ></g:select>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="name">Name:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:assemblyInstance,field:'name','errors')}">
                                    <input type="text" id="name" name="name" value="${fieldValue(bean:assemblyInstance,field:'name')}"/>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="subAssemblies">Sub Assemblies:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:assemblyInstance,field:'subAssemblies','errors')}">
                                    <g:select name="subAssemblies"
from="${SubAssembly.list()}"
size="5" multiple="yes" optionKey="id"
value="${assemblyInstance?.subAssemblies}" />

                                </td>
                            </tr> 
                        
                        </tbody>
                    </table>
                </div>
                <div class="buttons">
                    <span class="button"><g:actionSubmit class="save" value="Update" /></span>
                    <span class="button"><g:actionSubmit class="delete" onclick="return confirm('Are you sure?');" value="Delete" /></span>
                </div>
            </g:form>
        </div>
    </body>
</html>
