import org.codehaus.groovy.grails.plugins.springsecurity.Secured

class TaskModificationController extends BaseController {
    
    def index = { redirect(action:list,params:params) }

    // the delete, save and update actions only accept POST requests
    static allowedMethods = [delete:'POST', save:'POST', update:'POST']

    def list = {
        params.max = Math.min( params.max ? params.max.toInteger() : 10,  100)
        [ taskModificationInstanceList: TaskModification.list( params ), taskModificationInstanceTotal: TaskModification.count() ]
    }

    def show = {
        def taskModificationInstance = TaskModification.get( params.id )

        if(!taskModificationInstance) {
            flash.message = "TaskModification not found with id ${params.id}"
            redirect(action:list)
        }
        else { return [ taskModificationInstance : taskModificationInstance ] }
    }

    def delete = {
        def taskModificationInstance = TaskModification.get( params.id )
        if(taskModificationInstance) {
            try {
                taskModificationInstance.delete()
                flash.message = "TaskModification ${params.id} deleted"
                redirect(action:list)
            }
            catch(org.springframework.dao.DataIntegrityViolationException e) {
                flash.message = "TaskModification ${params.id} could not be deleted"
                redirect(action:show,id:params.id)
            }
        }
        else {
            flash.message = "TaskModification not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def edit = {
        def taskModificationInstance = TaskModification.get( params.id )

        if(!taskModificationInstance) {
            flash.message = "TaskModification not found with id ${params.id}"
            redirect(action:list)
        }
        else {
            return [ taskModificationInstance : taskModificationInstance ]
        }
    }

    def update = {
        def taskModificationInstance = TaskModification.get( params.id )
        if(taskModificationInstance) {
            if(params.version) {
                def version = params.version.toLong()
                if(taskModificationInstance.version > version) {
                    
                    taskModificationInstance.errors.rejectValue("version", "taskModification.optimistic.locking.failure", "Another user has updated this TaskModification while you were editing.")
                    render(view:'edit',model:[taskModificationInstance:taskModificationInstance])
                    return
                }
            }
            taskModificationInstance.properties = params
            if(!taskModificationInstance.hasErrors() && taskModificationInstance.save()) {
                flash.message = "TaskModification ${params.id} updated"
                redirect(action:show,id:taskModificationInstance.id)
            }
            else {
                render(view:'edit',model:[taskModificationInstance:taskModificationInstance])
            }
        }
        else {
            flash.message = "TaskModification not found with id ${params.id}"
            redirect(action:edit,id:params.id)
        }
    }

    def create = {
        def taskModificationInstance = new TaskModification()
        taskModificationInstance.properties = params
        return ['taskModificationInstance':taskModificationInstance]
    }

    def save = {
        def taskModificationInstance = new TaskModification(params)
        if(!taskModificationInstance.hasErrors() && taskModificationInstance.save()) {
            flash.message = "TaskModification ${taskModificationInstance.id} created"
            redirect(action:show,id:taskModificationInstance.id)
        }
        else {
            render(view:'create',model:[taskModificationInstance:taskModificationInstance])
        }
    }
}
