import org.codehaus.groovy.grails.plugins.springsecurity.Secured

@Secured(['ROLE_AppAdmin', 'ROLE_Manager', 'ROLE_InventoryManager'])
class InventoryLocationDetailedController extends BaseController {

    def filterService

    // the delete, save and update actions only accept POST requests
    static allowedMethods = [delete:'POST', save:'POST', update:'POST']

    @Secured(['ROLE_AppAdmin', 'ROLE_Manager', 'ROLE_InventoryManager', 'ROLE_InventoryUser'])
    def index = { redirect(action:list,params:params) }

    @Secured(['ROLE_AppAdmin', 'ROLE_Manager', 'ROLE_InventoryManager', 'ROLE_InventoryUser'])
    def list = {
        params.max = Math.min( params.max ? params.max.toInteger() : 100, 1000 )
        def associatedPropertyMax = 1000
        def associatedPropertyValues = [:]
        def inventoryStoreNameQuery = 'select distinct a.name from InventoryStore a where a.isActive = ? order by a.name'
        associatedPropertyValues.inventoryStoreList = InventoryStore.executeQuery(inventoryStoreNameQuery, [true], [max:associatedPropertyMax])

        if(!params.filter) {
            return [inventoryLocationInstanceList: InventoryLocation.list(params),
                    inventoryLocationInstanceTotal: InventoryLocation.count(),
                    associatedPropertyValues: associatedPropertyValues,
                    filterParams: params]
        }

        // filterPane:
        return[ inventoryLocationInstanceList: filterService.filter( params, InventoryLocation ),
                inventoryLocationInstanceTotal: filterService.count( params, InventoryLocation ),
                associatedPropertyValues: associatedPropertyValues,
                filterParams: com.zeddware.grails.plugins.filterpane.FilterUtils.extractFilterParams(params),
                params:params ]
    }

    @Secured(['ROLE_AppAdmin', 'ROLE_Manager', 'ROLE_InventoryManager', 'ROLE_InventoryUser'])
    def show = {

        // In the case of an actionSubmit button, rewrite action name from 'index'.
        if(params._action_Show)
            params.action='show'

        def inventoryLocationInstance = InventoryLocation.get( params.id )

        if(!inventoryLocationInstance) {
            flash.message = "InventoryLocation not found with id ${params.id}"
            redirect(action:list)
        }
        else { return [ inventoryLocationInstance : inventoryLocationInstance ] }
    }

    def delete = {
        def inventoryLocationInstance = InventoryLocation.get( params.id )
        if(inventoryLocationInstance) {
            try {
                inventoryLocationInstance.delete(flush:true)
                flash.message = "InventoryLocation ${params.id} deleted"
                redirect(action:list)
            }
            catch(org.springframework.dao.DataIntegrityViolationException e) {
                flash.message = "InventoryLocation ${params.id} could not be deleted"
                redirect(action:show,id:params.id)
            }
        }
        else {
            flash.message = "InventoryLocation not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def edit = {

        // In the case of an actionSubmit button, rewrite action name from 'index'.
        if(params._action_Edit)
            params.action='edit'

        def inventoryLocationInstance = InventoryLocation.get( params.id )

        if(!inventoryLocationInstance) {
            flash.message = "InventoryLocation not found with id ${params.id}"
            redirect(action:list)
        }
        else {
            return [ inventoryLocationInstance : inventoryLocationInstance ]
        }
    }

    def update = {
        def inventoryLocationInstance = InventoryLocation.get( params.id )
        if(inventoryLocationInstance) {
            if(params.version) {
                def version = params.version.toLong()
                if(inventoryLocationInstance.version > version) {

                    inventoryLocationInstance.errors.rejectValue("version", "default.optimistic.locking.failure")
                    render(view:'edit',model:[inventoryLocationInstance:inventoryLocationInstance])
                    return
                }
            }
            inventoryLocationInstance.properties = params
            if(!inventoryLocationInstance.hasErrors() && inventoryLocationInstance.save(flush: true)) {
                flash.message = "InventoryLocation ${params.id} updated"
                redirect(action:show,id:inventoryLocationInstance.id)
            }
            else {
                render(view:'edit',model:[inventoryLocationInstance:inventoryLocationInstance])
            }
        }
        else {
            flash.message = "InventoryLocation not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def create = {
        def inventoryLocationInstance = new InventoryLocation()
        inventoryLocationInstance.properties = params
        return ['inventoryLocationInstance':inventoryLocationInstance]
    }

    def save = {
        def inventoryLocationInstance = new InventoryLocation(params)
        if(!inventoryLocationInstance.hasErrors() && inventoryLocationInstance.save(flush: true)) {
            flash.message = "InventoryLocation ${inventoryLocationInstance.id} created"
            redirect(action:show,id:inventoryLocationInstance.id)
        }
        else {
            render(view:'create',model:[inventoryLocationInstance:inventoryLocationInstance])
        }
    }
}
