import org.codehaus.groovy.grails.plugins.springsecurity.Secured

@Secured(['ROLE_AppAdmin', 'ROLE_Manager', 'ROLE_InventoryManager'])
class SupplierDetailedController extends BaseController {

    def filterService

    def index = { redirect(action:list,params:params) }

    // the delete, save and update actions only accept POST requests
    static allowedMethods = [delete:'POST', save:'POST', update:'POST']

    def list = {
        params.max = Math.min( params.max ? params.max.toInteger() : 10,  100)
        def associatedPropertyMax = 1000
        def associatedPropertyValues = [:]
        def supplierTypeNameQuery = 'select distinct a.name from SupplierType a where a.isActive = ? order by a.name'
        associatedPropertyValues.supplierTypeList = SupplierType.executeQuery(supplierTypeNameQuery, [true], [max:associatedPropertyMax])

        if(!params.filter) {
            return [supplierInstanceList: Supplier.list(params),
                    supplierInstanceTotal: Supplier.count(),
                    associatedPropertyValues: associatedPropertyValues,
                    filterParams: params]
        }

        // filterPane:
        return[ supplierInstanceList: filterService.filter( params, Supplier ),
                supplierInstanceTotal: filterService.count( params, Supplier ),
                associatedPropertyValues: associatedPropertyValues,
                filterParams: com.zeddware.grails.plugins.filterpane.FilterUtils.extractFilterParams(params),
                params:params ]
    }

    def show = {

        // In the case of an actionSubmit button, rewrite action name from 'index'.
        if(params._action_Show)
            params.action='show'

        def supplierInstance = Supplier.get( params.id )

        if(!supplierInstance) {
            flash.message = "Supplier not found with id ${params.id}"
            redirect(action:list)
        }
        else { return [ supplierInstance : supplierInstance ] }
    }

    def delete = {
        def supplierInstance = Supplier.get( params.id )
        if(supplierInstance) {
            try {
                supplierInstance.delete(flush:true)
                flash.message = "Supplier ${params.id} deleted"
                redirect(action:list)
            }
            catch(org.springframework.dao.DataIntegrityViolationException e) {
                flash.message = "Supplier ${params.id} could not be deleted"
                redirect(action:show,id:params.id)
            }
        }
        else {
            flash.message = "Supplier not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def edit = {

        // In the case of an actionSubmit button, rewrite action name from 'index'.
        if(params._action_Edit)
            params.action='edit'

        def supplierInstance = Supplier.get( params.id )

        if(!supplierInstance) {
            flash.message = "Supplier not found with id ${params.id}"
            redirect(action:list)
        }
        else {
            return [ supplierInstance : supplierInstance ]
        }
    }

    def update = {
        def supplierInstance = Supplier.get( params.id )
        if(supplierInstance) {
            if(params.version) {
                def version = params.version.toLong()
                if(supplierInstance.version > version) {

                    supplierInstance.errors.rejectValue("version", "default.optimistic.locking.failure")
                    render(view:'edit',model:[supplierInstance:supplierInstance])
                    return
                }
            }
            supplierInstance.properties = params
            if(!supplierInstance.hasErrors() && supplierInstance.save(flush: true)) {
                flash.message = "Supplier ${params.id} updated"
                redirect(action:show,id:supplierInstance.id)
            }
            else {
                render(view:'edit',model:[supplierInstance:supplierInstance])
            }
        }
        else {
            flash.message = "Supplier not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def create = {
        def supplierInstance = new Supplier()
        supplierInstance.properties = params
        return ['supplierInstance':supplierInstance]
    }

    def save = {
        def supplierInstance = new Supplier(params)
        if(!supplierInstance.hasErrors() && supplierInstance.save(flush: true)) {
            flash.message = "Supplier ${supplierInstance.id} created"
            redirect(action:show,id:supplierInstance.id)
        }
        else {
            render(view:'create',model:[supplierInstance:supplierInstance])
        }
    }
}
