

<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>InventoryLocation List</title>
        <filterpane:includes />
        <nav:resources override="true"/>
    </head>
    <body>
        <div class="nav">
            <nav:renderSubItems group="navAlt"/>
        </div>
        <div class="body">
            <g:render template="/shared/messages" />

            <filterpane:currentCriteria domainBean="InventoryLocation"
                                        action="list"
                                        dateFormat="EEE, dd-MMM-yyyy"
                                        removeImgDir="images"
                                        removeImgFile="bullet_delete.png"
                                        title="Search"/>

            <div class="paginateButtons">
                Results: ${inventoryLocationInstanceList.size()} / ${inventoryLocationInstanceTotal}
                <span class="searchButtons">
                    <filterpane:filterButton text="Search" appliedText="Change Search" />
                </span>
            </div>

            <br />

            <g:if test="${inventoryLocationInstanceList.size() > 0}">
                <div class="list">
                    <table>
                        <thead>
                        <tr>

                            <g:sortableColumn property="id" title="Id" params="${filterParams}" />

                            <g:sortableColumn property="name" title="Name" params="${filterParams}" />

                            <g:sortableColumn property="inventoryStore" title="Inventory Store" params="${filterParams}" />

                            <g:sortableColumn property="isActive" title="Is Active" params="${filterParams}" />

                            <th></th>

                        </tr>
                        </thead>
                        <tbody>
                        <g:each in="${inventoryLocationInstanceList}" status="i" var="inventoryLocationInstance">
                            <tr class="${(i % 2) == 0 ? 'clickableOdd' : 'clickableEven'}">


                                <td onclick='window.location = "${request.getContextPath()}/inventoryLocationDetailed/show/${inventoryLocationInstance.id}"'>
                                    ${fieldValue(bean:inventoryLocationInstance, field:'id')}
                                </td>

                                <td onclick='window.location = "${request.getContextPath()}/inventoryLocationDetailed/show/${inventoryLocationInstance.id}"'>
                                    ${fieldValue(bean:inventoryLocationInstance, field:'name')}
                                </td>

                                <td onclick='window.location = "${request.getContextPath()}/inventoryLocationDetailed/show/${inventoryLocationInstance.id}"'>
                                    ${fieldValue(bean:inventoryLocationInstance, field:'inventoryStore')}
                                </td>

                                <td onclick='window.location = "${request.getContextPath()}/inventoryLocationDetailed/show/${inventoryLocationInstance.id}"'>
                                    ${fieldValue(bean:inventoryLocationInstance, field:'isActive')}
                                </td>

                                <td class="notClickable">
                                    <g:link action="show" id="${inventoryLocationInstance.id}">
                                        <img  src="${resource(dir:'images/skin',file:'database_go.png')}" alt="Show" />
                                    </g:link>
                                </td>

                            </tr>
                        </g:each>
                        </tbody>
                    </table>
                </div>
            </g:if>

            <div class="paginateButtons">
                <g:paginate total="${inventoryLocationInstanceTotal}" params="${filterParams}" />
            </div>

            <filterpane:filterPane domainBean="InventoryLocation"
                                   title="Search"
                                   action="list"
                                   class="overlayPane"
                                   associatedProperties="inventoryStore.name"
                                   filterPropertyValues="${['inventoryStore.name':[values: associatedPropertyValues.inventoryStoreList]]}" />
        </div>
    </body>
</html>
