
    <div class="dialog">
        <table>
            <tbody>

                <g:if test="${taskInstance.parentTask}">
                    <tr class="prop">
                        <td valign="top" class="name">Parent Task:</td>

                        <td valign="top" class="value">
                            <g:link controller="taskDetailed" action="show" id="${taskInstance.parentTask.id}">
                                ${taskInstance.parentTask.encodeAsHTML()}
                            </g:link>
                        </td>

                    </tr>
                </g:if>

                <tr class="prop">
                    <td valign="top" class="name">Comment:</td>

                    <td valign="top" class="value">${fieldValue(bean:taskInstance, field:'comment')}</td>

                </tr>

                <tr class="prop">
                    <td valign="top" class="name">Target Start:</td>

                    <td valign="top" class="value">
                        <g:formatDate date="${taskInstance.targetStartDate}" format="EEE, dd-MMM-yyyy"/>
                    </td>

                </tr>

                <tr class="prop">
                    <td valign="top" class="name">Target Completion:</td>

                    <td valign="top" class="value">
                        <g:formatDate date="${taskInstance.targetCompletionDate}" format="EEE, dd-MMM-yyyy"/>
                    </td>

                </tr>

                <tr class="prop">
                    <td valign="top" class="name">

                        <jsUtil:toggleControl toggleId="modifications"
                                                                imageId="modificationsImg"
                                                                closedImgUrl="${resource(dir:'images/skin',file:'bullet_toggle_plus.png')}"
                                                                openImgUrl="${resource(dir:'images/skin',file:'bullet_toggle_minus.png')}"
                                                                effect="fade"
                                                                text="Modifications"
                                                                />
                    </td>

                    <td  valign="top" style="text-align:left;" class="value">
                        <div id="modifications" style="display:none;">
                            <g:render template="showTaskModifications" />
                        </div>
                    </td>
                </tr>

                <tr class="prop">
                    <td valign="top" class="name">Primary Asset:</td>

                    <td valign="top" class="value"><g:link controller="assetDetailed" action="show" id="${taskInstance?.primaryAsset?.id}">${taskInstance?.primaryAsset?.encodeAsHTML()}</g:link></td>

                </tr>

                <tr class="prop">
                    <td valign="top" class="name">Associated Assets:</td>

                    <td  valign="top" style="text-align:left;" class="value">
                        <ul>
                        <g:each var="a" in="${taskInstance.associatedAssets}">
                            <li>${a?.encodeAsHTML()}</li>
                        </g:each>
                        </ul>
                    </td>

                </tr>

                <tr class="prop">
                    <td valign="top" class="name">Priority:</td>

                    <td valign="top" class="value">${taskInstance?.taskPriority?.encodeAsHTML()}</td>

                </tr>

                <tr class="prop">
                    <td valign="top" class="name">Positive Fault:</td>

                    <td valign="top" class="value">${fieldValue(bean:taskInstance, field:'positiveFault')}</td>

                </tr>

                <tr class="prop">
                    <td valign="top" class="name">Group:</td>

                    <td valign="top" class="value">${taskInstance?.taskGroup?.encodeAsHTML()}</td>

                </tr>

                <tr class="prop">
                    <td valign="top" class="name">Type:</td>

                    <td valign="top" class="value">${taskInstance?.taskType?.encodeAsHTML()}</td>

                </tr>

                <tr class="prop">
                    <td valign="top" class="name">Lead Person:</td>

                    <td valign="top" class="value">${taskInstance?.leadPerson?.encodeAsHTML()}</td>

                </tr>

                <tr class="prop">
                    <td valign="top" class="name">Assigned Groups:</td>

                    <td  valign="top" style="text-align:left;" class="value">
                        <ul>
                        <g:each var="a" in="${assignedGroupList}">
                            <li><g:link controller="assignedGroupDetailed" action="edit" id="${a.id}" params="['task.id':taskInstance.id]">${a?.encodeAsHTML()}</g:link></li>
                        </g:each>
                        </ul>
                        <g:link controller="assignedGroupDetailed" action="create" params="['task.id':taskInstance.id]">+Add Group</g:link>
                    </td>

                </tr>


                <tr class="prop">
                    <td valign="top" class="name">Assigned Persons:</td>

                    <td  valign="top" style="text-align:left;" class="value">
                        <ul>
                        <g:each var="a" in="${assignedPersonList}">
                            <li><g:link controller="assignedPersonDetailed" action="edit" id="${a.id}" params="['task.id':taskInstance.id]">${a?.encodeAsHTML()}</g:link></li>
                        </g:each>
                        </ul>
                        <g:link controller="assignedPersonDetailed" action="create" params="['task.id':taskInstance?.id]">+Add Person</g:link>
                    </td>

                </tr>

            </tbody>
        </table>
    </div>

    <div class="buttons" id="taskControlButtons">
        <g:render template="showTaskControlButtons" />
    </div>

    <br />

    <div id="entryFaultContainer">
        <g:if test="${entryFaultList.isEmpty()}">
            <h1>No Faults</h1>
            <br />
        </g:if>
        <g:else>
            <g:render template="/entryDetailed/list"
                                model="['entryList':entryFaultList]" />
        </g:else>
    </div>

    <br />

    <div id="createEntryFaultContainer" style="display:none;"></div>

    <div style="text-align:right;" id="entryFaultButton">
        <span class="buttons">
            <input type="button"
                        class="add"
                        value="Add Fault"
                        onclick="getCreateEntryForm(jQuery('#entryFaultContainer'),
                                                                            jQuery('#entryFaultButton'),
                                                                            {target: '#createEntryFaultContainer',
                                                                            taskId: ${taskInstance?.id},
                                                                            entryTypeId: 1})" />
        </span>
    </div>

    <br />

    <div id="entryCauseContainer">
        <g:if test="${entryCauseList.isEmpty()}">
            <h1>No Causes</h1>
            <br />
        </g:if>
        <g:else>
            <g:render template="/entryDetailed/list"
                                model="['entryList':entryCauseList]" />
        </g:else>
    </div>

    <br />

    <div id="createEntryCauseContainer" style="display:none;"></div>

    <div style="text-align:right;" id="entryCauseButton">
        <span class="buttons">
            <input type="button"
                        class="add"
                        value="Add Cause"
                        onclick="getCreateEntryForm(jQuery('#entryCauseContainer'),
                                                                            jQuery('#entryCauseButton'),
                                                                            {target: '#createEntryCauseContainer',
                                                                            taskId: ${taskInstance?.id},
                                                                            entryTypeId: 2})" />
        </span>
    </div>

    <br />

    <div id="workDoneContainer">
        <g:if test="${entryWorkDoneList.isEmpty()}">
            <h1>No Work Done</h1>
            <br />
        </g:if>
        <g:else>
            <g:render template="/entryDetailed/list"
                                model="['entryList':entryWorkDoneList]" />
        </g:else>
    </div>

    <br />

    <div id="createWorkDoneContainer" style="display:none;"></div>

    <div style="text-align:right;" id="workDoneButton">
        <span class="buttons">
            <input type="button"
                        class="add"
                        value="Add Work Done"
                        onclick="getCreateEntryForm(jQuery('#workDoneContainer'),
                                                                            jQuery('#workDoneButton'),
                                                                            {target: '#createWorkDoneContainer',
                                                                            taskId: ${taskInstance?.id},
                                                                            entryTypeId: 3})" />
        </span>
    </div>
