

<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>Create InventoryItemPurchase</title>
        <nav:resources override="true"/>
        <resource:dateChooser />
    </head>
    <body>
        <div class="nav">
            <h1>Order Inventory</h1>
        </div>
        <div class="body">
            <g:render template="/shared/messages" />
            <g:if test="${!costCodes}" >
                <div class="errors">
                    <ul>
                        <li><g:message code="inventoryItemPurchase.costCodes.not.found" /><li>
                </div>
            </g:if>
            <g:hasErrors bean="${inventoryItemPurchaseInstance}">
            <div class="errors">
                <g:renderErrors bean="${inventoryItemPurchaseInstance}" as="list" />
            </div>
            </g:hasErrors>
            <g:form action="save" method="post" >
                <g:hiddenField name="inventoryItem.id" value="${inventoryItemPurchaseInstance?.inventoryItem?.id}" />
                <g:hiddenField name="returnTo" value="${params.returnTo}" />
                <div class="dialog">
                    <table>
                        <tbody>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="inventoryItem">Inventory Item:</label>
                                </td>
                                <td valign="top" class="value">
                                    <g:link controller="inventoryItemDetailed"
                                                    action="show"
                                                    id="${inventoryItemPurchaseInstance.inventoryItem.id}">
                                        ${inventoryItemPurchaseInstance.inventoryItem.encodeAsHTML()}
                                    </g:link>
                                </td>
                            </tr>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="purchaseOrderNumber">Purchase Order #:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryItemPurchaseInstance,field:'purchaseOrderNumber','errors')}">
                                    <input type="text" maxlength="50" id="purchaseOrderNumber" name="purchaseOrderNumber" value="${fieldValue(bean:inventoryItemPurchaseInstance,field:'purchaseOrderNumber')}"/>
                                    <g:helpBalloon code="inventoryItemPurchase.purchaseOrderNumber" />
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="date">Date:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryItemPurchaseInstance,field:'date','errors')}">
                                    <richui:dateChooser name="date" format="dd-MM-yyyy" value="${inventoryItemPurchaseInstance.date}" />
                                    <g:helpBalloon code="inventoryItemPurchase.order.placed.date" />
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="costCode">Cost Code:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryItemPurchaseInstance,field:'costCode','errors')}">
                                    <g:select optionKey="id"
                                                        from="${ costCodes }"
                                                        name="costCode.id"
                                                        value="${inventoryItemPurchaseInstance?.costCode?.id}"
                                                        noSelection="['null':/${g.message(code:'default.please.select.text')}/]">
                                    </g:select>
                                    <g:helpBalloon code="inventoryItemPurchase.cost.code" />
                                </td>
                            </tr>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="taskBudgetStatus">Budget Status:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryItemPurchaseInstance,field:'taskBudgetStatus','errors')}">
                                    <g:select optionKey="id"
                                                        from="${ TaskBudgetStatus.findAllByIsActive(true).sort { p1, p2 -> p1.name.compareToIgnoreCase(p2.name) } }"
                                                        name="taskBudgetStatus.id"
                                                        value="${inventoryItemPurchaseInstance?.taskBudgetStatus?.id}"
                                                        noSelection="['null':/${g.message(code:'default.please.select.text')}/]">
                                    </g:select>
                                    <g:helpBalloon code="inventoryItemPurchase.task.budget.status" />
                                </td>
                            </tr>
                        
                             <tr class="prop">
                                 <td valign="top" class="name">
                                    <label for="supplier">Supplier:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryItemPurchaseInstance,field:'supplier','errors')}">
                                    <g:select optionKey="id"
                                                        from="${ Supplier.findAllByIsActive(true).sort { p1, p2 -> p1.name.compareToIgnoreCase(p2.name) } }"
                                                        name="supplier.id"
                                                        value="${inventoryItemPurchaseInstance?.supplier?.id}"
                                                        noSelection="['null':/${g.message(code:'default.please.select.text')}/]">
                                    </g:select>
                                    <g:helpBalloon code="inventoryItemPurchase.supplier" />
                                    <p><g:link controller="supplierDetailed" action="create">+Add Supplier</g:link></p>
                                </td>
                            </tr>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="quantity">Quantity:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryItemPurchaseInstance,field:'quantity','errors')}">
                                    <input type="text" id="quantity" name="quantity" value="${fieldValue(bean:inventoryItemPurchaseInstance,field:'quantity')}" />
                                    ${inventoryItemPurchaseInstance.inventoryItem.unitOfMeasure.encodeAsHTML()}
                                    <g:helpBalloon code="inventoryItemPurchase.quantity" />
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="orderValue">Order Value:</label>
                                </td>
                                <td valign="top" class="value">
                                    <input  class="medium ${hasErrors(bean:inventoryItemPurchaseInstance,field:'orderValueAmount','errors')}"
                                                    type="text" id="orderValueAmount" name="orderValueAmount"
                                                    value="${inventoryItemPurchaseInstance.orderValueAmount}" />
                                    <g:currencySelect name="orderValueCurrency"
                                                                        value="${inventoryItemPurchaseInstance?.orderValueCurrency}"
                                                                        from="${grailsApplication.config.currencyList}">
                                    </g:currencySelect>
                                    <g:helpBalloon code="inventoryItemPurchase.order.value" />
                                </td>
                            </tr>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="comment">Comment:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryItemPurchaseInstance,field:'comment','errors')}">
                                    <textarea rows="5" cols="40" name="comment">${fieldValue(bean:inventoryItemPurchaseInstance, field:'comment')}</textarea>
                                </td>
                            </tr>
                        
                        </tbody>
                    </table>
                </div>
                <div class="buttons">
                    <span class="button"><input class="save" type="submit" value="Create" /></span>
                </div>
            </g:form>
        </div>
    </body>
</html>
