<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>Equipment Register (OH&amp;S) Report</title>
        <nav:resources override="true"/>
        <resource:dateChooser />
    </head>
    <body>
        <div class="nav">
            <nav:renderSubItems group="nav"/>
        </div>
        <div class="body">
            <h1>Equipment Register (OH&amp;S) Report</h1>
            <g:render template="/shared/messages" />
            <div class="dialog">
                <table>
                    <tbody>

                        <g:jasperForm controller="report"
                                                    action="equipmentRegisterOhs"
                                                    jasper="equipmentRegisterOhs"
                                                    name="Equipment Register (OH&amp;S)">

                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label>Date:</label>
                                </td>
                                <td valign="top" class="value">
                                    <richui:dateChooser name="startDate" id="equipmentRegisterOhs_startDate" format="dd-MM-yyyy" value="${new Date()-7}" />
                                    to
                                    <richui:dateChooser name="endDate" id="equipmentRegisterOhs_endDate" format="dd-MM-yyyy" value="${new Date()}" />
                                </td>
                            </tr>

                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label>Section:</label>
                                </td>
                                <td valign="top" class="value">
                                    <g:select optionKey="id"
                                                        from="${Section.findAllByIsActive(true).sort { p1, p2 -> p1.name.compareToIgnoreCase(p2.name) }}"
                                                        name="section.id">
                                    </g:select>
                                </td>
                            </tr>

                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label>Report:</label>
                                </td>
                                <td valign="top" class="value">
                                    <custom:jasperButtons jasper="equipmentRegisterOhs" format="PDF, XLS" text="PDF" />
                                </td>
                            </tr>

                        </g:jasperForm>

                    </tbody>
                </table>
            </div> <!--End dialog-->
        </div> <!--End body-->
    </body>
</html>
