

<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>Create Entry</title>         
    </head>
    <body>
        <div class="nav">
            <span class="menuButton"><a class="home" href="${createLinkTo(dir:'')}">Home</a></span>
            <span class="menuButton"><g:link class="list" action="list">Entry List</g:link></span>
        </div>
        <div class="body">
            <h1>Create Entry</h1>
            <g:if test="${flash.message}">
            <div class="message">${flash.message}</div>
            </g:if>
            <g:hasErrors bean="${entryInstance}">
            <div class="errors">
                <g:renderErrors bean="${entryInstance}" as="list" />
            </div>
            </g:hasErrors>
            <g:form action="save" method="post" >
                <g:hiddenField name="task.id" value="${entryInstance.task.id}" />
                <div class="dialog">
                    <table>
                        <tbody>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="task">Task:</label>
                                </td>
                                <td valign="top" class="name">
                                    ${entryInstance?.task?.name}
                                </td>
                            </tr>

                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="date">Date:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:entryInstance,field:'date','errors')}">
                                    <g:datePicker name="date" precision='day' value="${entryInstance?.date}" ></g:datePicker>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="comments">Comments:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:entryInstance,field:'comments','errors')}">
                                    <textarea rows="5" cols="40" name="comments">${fieldValue(bean:entryInstance, field:'comments')}</textarea>
                                </td>
                            </tr> 
                        

                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="durationHours">Duration Hours:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:entryInstance,field:'durationHours','errors')}">
                                    <input type="text" id="durationHours" name="durationHours" value="${fieldValue(bean:entryInstance,field:'durationHours')}" />
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="durationMinutes">Duration Minutes:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:entryInstance,field:'durationMinutes','errors')}">
                                    <input type="text" id="durationMinutes" name="durationMinutes" value="${fieldValue(bean:entryInstance,field:'durationMinutes')}" />
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="entryType">Entry Type:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:entryInstance,field:'entryType','errors')}">
                                    <g:select optionKey="id" from="${EntryType.list()}" name="entryType.id" value="${entryInstance?.entryType?.id}" ></g:select>
                                </td>
                            </tr> 
                        
                        </tbody>
                    </table>
                </div>
                <div class="buttons">
                    <span class="button"><input class="save" type="submit" value="Create" /></span>
                </div>
            </g:form>
        </div>
    </body>
</html>
