
function showButton(button) {
    button.show(600, function() {
        if(jQuery.browser.msie) {
            jQuery(this).get(0).style.removeAttribute('filter'); // Remove blur/fuzzy text in IE.
        }
    });
}

function createEntryFormInit(target, listContainer, button) {

    // Show.
    target.slideDown(800);
    // Scroll the window.
    jQuery('html,body').animate({scrollTop: target.offset().top - 70}, 900, function() {
        target.find(':input[name="comment"]').focus();
    });
    // Register 'submit_*' input button click handlers.
    target.find('input[name^="submit_"]').click(function(){
        target.find(':input[name="submitAction"]').val(jQuery(this).attr('name'));
        target.find('form:first').submit();
    });
    // Redirect form submit to use our function.
    var eventData = {listContainer:listContainer, source:target, button:button};
    target.find('form:first').submit(eventData, submitCreateEntryForm);
    // Register the close img click handler.
    target.find('.pane_close img').click(function(){
        target.slideUp(600);
        showButton(button);
    });

}

// Submit a create Entry form via AJAX.
function submitCreateEntryForm(event) {

    var actionUrl = getContextPath()+"/entryDetailed/ajaxSave/";

    event.preventDefault();
    var listContainer = event.data.listContainer;
    var source = event.data.source;
    var button = event.data.button;
    var form = source.find('form:first');

    // On success reload listContainer.
    function success(data, textStatus, jqXHR) {
        source.hide();
        applyElementUpdates(data);
        showButton(button);
    }

    // On create failure controller sets 403 and returns the form template.
    function error(jqXHR, textStatus, errorThrown) {
        if(jqXHR.status == 403 && jqXHR.responseText) {
            source.html(jqXHR.responseText);
            createEntryFormInit(source, listContainer, button);
        }
        else {
            source.html(savedHtml);
            source.prepend(errorIndication(jqXHR, textStatus, errorThrown).show()).slideDown(600);
            // Scroll the window.
            jQuery('html,body').animate({scrollTop: source.offset().top - 70}, 900, function() {
                source.find(':input[name="comment"]').focus();
            });
        }
    }

    // Start.
    var savedHtml = source.children().detach();
    var params = form.serializeArray();
    params.push({name:'target', value:listContainer.selector});
    source.html(loadingIndication().show()).slideDown(600);

    jQuery.ajax({
        url: actionUrl,
        data: params,
        type: 'POST',
        dataType: 'json',
        success: success,
        error: error
    });
}

// Get a create Entry form via AJAX.
// @listContainer Container object to reload list into.
// @button Button object used to trigger this function.
// @params Params map to pass to actionUrl.
// @params.target Selector indicating target to load response into.
function getCreateEntryForm(listContainer, button, params) {

    var actionUrl = getContextPath()+"/entryDetailed/ajaxCreate/";
    var target = jQuery(params.target);

    // On success load target.
    function success(data, textStatus, jqXHR) {
        applyElementUpdates(data);
        createEntryFormInit(target, listContainer, button);
    }

    // On error show controller responseText or show default error.
    function error(jqXHR, textStatus, errorThrown) {
        if(jqXHR.status == 403 && jqXHR.responseText) {
            target.html(jqXHR.responseText);
        }
        else {
            target.html(errorIndication(jqXHR, textStatus, errorThrown).show());
        }
        showButton(button);
    }

    // Start.
    button.hide(600);
    target.html(loadingIndication().show()).slideDown(600);

    jQuery.ajax({
        url: actionUrl,
        data: params,
        type: 'POST',
        dataType: 'json',
        success: success,
        error: error
    });
}

