
        <div class="dialog">
            <table>
                <tbody>

                    <tr class="prop">
                        <td valign="top" class="name">Procedure Id:</td>
                        <td valign="top" class="value">
                            ${fieldValue(bean:taskProcedureRevision, field:'taskProcedureId')}
                        </td>
                    </tr>

                    <tr class="prop">
                        <td valign="top" class="name">Linked Task:</td>
                        <td valign="top" class="value">
                            <g:link controller="taskDetailed"
                                            action="show"
                                            id="${taskProcedureRevision.linkedTask.id}">
                                ${taskProcedureRevision.linkedTask.encodeAsHTML()}
                            </g:link>
                        </td>
                    </tr>

                    <tr class="prop">
                        <td valign="top" class="name">Linked Asset:</td>
                        <td valign="top" class="value">
                            <g:render template="/shared/assetTreeCompact" model="['assetInstance': taskProcedureRevision.linkedTask.primaryAsset]" />
                        </td>
                    </tr>

                    <tr class="prop">
                        <td valign="top" class="name">Revision:</td>
                        <td valign="top" class="value">
                            ${fieldValue(bean:taskProcedureRevision, field:'revisionDateString')}
                        </td>
                    </tr>

                </tbody>
            </table>
        </div>
        <div class="buttons">
            <g:form controller="taskProcedureDetailed">
                <input type="hidden" name="id" value="${taskProcedureRevision.taskProcedureId}" />
                Latest Revision: ${taskProcedureRevision?.taskProcedure.revision}
                <span class="button">
                    <g:actionSubmit class="edit" value="Edit" />
                </span>
                <span class="button">
                    <g:actionSubmit class="go" value="Show" />
                </span>
            </g:form>
        </div>

        <br />

        <g:if test="${taskProcedureRevision.documentReferences}">
            <div class="list">
                <table>
                    <thead>
                        <tr>
                            <th>Document Reference</th>
                            <th>Location</th>
                        </tr>
                    </thead>
                    <tbody>
                        <g:each in="${taskProcedureRevision.documentReferences}" status="i" var="docRef">
                            <tr class="${(i % 2) == 0 ? 'odd' : 'even'}">

                                <td valign="top" class="name">
                                    ${fieldValue(bean:docRef, field:'name')}
                                </td>

                                <td  valign="top" style="text-align:left;" class="value">
                                    <custom:easyUrl url="${docRef.location}" />
                                </td>

                            </tr>
                        </g:each>

                    </tbody>
                </table>
            </div>
        </g:if>

        <br />

        <g:if test="${taskProcedureRevision.maintenanceActions}">
            <div class="list">
                <table>
                    <thead>
                        <tr>
                            <th>Step</th>
                            <th>Assembly</th>
                            <th>Description</th>
                            <th>Page Ref</th>
                            <th>Condition</th>
                        </tr>
                    </thead>
                    <tbody>
                        <g:each in="${taskProcedureRevision.maintenanceActions}" status="i" var="maintenanceAction">
                            <tr class="${(i % 2) == 0 ? 'odd' : 'even'}">

                                <td valign="top" class="name">
                                    ${fieldValue(bean:maintenanceAction, field:'procedureStepNumber')}
                                </td>

                                <td  valign="top" style="text-align:left;" class="value">
                                    <g:if test="${maintenanceAction.assetSubItem}">
                                        ${maintenanceAction.assetSubItem.parentItem?.encodeAsHTML()}
                                        --
                                        ${maintenanceAction.assetSubItem.encodeAsHTML()}
                                    </g:if>
                                </td>

                                <td  valign="top" style="text-align:left;" class="value">
                                    ${fieldValue(bean:maintenanceAction, field:'description')}
                                </td>

                                <td  valign="top" style="text-align:left;" class="value">
                                    ${maintenanceAction.pageRef.encodeAsHTML() ?: '-'}
                                </td>

                                <td  valign="top" style="text-align:left; white-space:nowrap;" class="value">
                                    ${'A | B | C | D'}
                                </td>

                            </tr>
                        </g:each>

                    </tbody>
                </table>
            </div>
        </g:if>