import org.codehaus.groovy.grails.plugins.springsecurity.Secured

@Secured(['ROLE_AppAdmin', 'ROLE_Manager', 'ROLE_TaskManager', 'ROLE_TaskUser'])
class EntryDetailedController extends BaseController {

    def authService
    def taskService

    def index = { redirect(action:list,params:params) }

    // the delete, save and update actions only accept POST requests
    static allowedMethods = [delete:'POST', save:'POST', update:'POST']

    def list = {
        if(!params.max) params.max = 10
        [ entryInstanceList: Entry.list( params ) ]
    }

    def show = {
        def entryInstance = Entry.get( params.id )

        if(!entryInstance) {
            flash.message = "Entry not found with id ${params.id}"
            redirect(controller: 'taskDetailed', action: 'search')
        }
        else { return [ entryInstance : entryInstance ] }
    }

    def delete = {
        def entryInstance = Entry.get( params.id )
        if(entryInstance) {
            if(entryInstance.enteredBy.loginName == authService.currentUser.loginName) {
                def taskID = entryInstance.task.id
                entryInstance.delete(flush:true)
                flash.message = "Entry ${params.id} deleted"
                redirect(controller: 'taskDetailed', action: 'show', id: taskID)
            }
            else {
                flash.message = "You may only delete your own entries."
                redirect(action:show,id:entryInstance.id)
            }

        }
        else {
            flash.message = "Entry not found with id ${params.id}"
            redirect(controller: "taskDetailed", action:"search")
        }
    }

    def edit = {
        def entryInstance = Entry.get( params.id )
        if(!entryInstance) {
                flash.message = "Entry not found with id ${params.id}"
                redirect(controller: "taskDetailed", action:"search")
        }
        else {

            if(entryInstance.enteredBy.loginName == authService.currentUser.loginName) {
                return [ entryInstance : entryInstance ]
            }
            else {
                flash.message = "You may only edit your own entries."
                redirect(action:show,id:entryInstance.id)
            }

        }
    }

    def update = {
        def entryInstance = Entry.get( params.id )
        if(entryInstance) {
            // The update method only accepts post requests, so this is just in case.
            if(entryInstance.enteredBy.loginName == authService.currentUser.loginName) {
                entryInstance.properties = params
                if(!entryInstance.hasErrors() && entryInstance.save(flush: true)) {
                    flash.message = "Entry ${params.id} updated"
                    redirect(action:show,id:entryInstance.id)
                }
                else {
                    render(view:'edit',model:[entryInstance:entryInstance])
                }
            }
            else {
                flash.message = "You may only edit your own entries."
                redirect(action:show,id:entryInstance.id)
            }
        }
        else {
            flash.message = "Entry not found with id ${params.id}"
            redirect(controller: "taskDetailed", action:"search")
        }
    }

    def createMaintenanceAction = {

//         if(!params.taskInstance?.id || !params.entryType?.id) {
//             flash.message = g.message(code:"entry.create.no.params")
//             redirect(controller:"taskDetailed", action:"search")
//             return
//         }

        def taskInstance = Task.read(params.taskInstance.id)
        println taskInstance
        render "Done"
    }

    def create = {
        if(!params.taskInstance?.id || !params.entryType?.id) {
            flash.message = g.message(code:"entry.create.no.params")
            redirect(controller:"taskDetailed", action:"search")
            return
        }

        def taskInstance = Task.read(params.taskInstance.id)

        if(!taskInstance) {
            flash.message = g.message(code:"task.notFound")
            redirect(controller:"taskDetailed", action:"search")
            return
        }

        // Check for Complete task.
        if(taskInstance.taskStatus.id == 3) {
            flash.errorMessage = g.message(code:"task.operationNotPermittedOnCompleteTask")
            redirect(controller:"taskDetailed", action:"show", id: taskInstance.id)
            return
        }

        def entryInstance = new Entry()
        entryInstance.task = taskInstance
        entryInstance.entryType = EntryType.read(params.entryType.id)
        return ['entryInstance': entryInstance]
    } // create

    def save = {
        def result = taskService.saveEntry(params)

        if(!result.error) {
            flash.message = "Entry created."
            redirect(controller: "taskDetailed", action: "show", id: result.taskId)
            return
        }

        if(result.error.code != "default.create.failure") {
            params.errorMessage = g.message(code: result.error.code)
        }

        render(view:'create',model:[entryInstance: result.entryInstance])
    } // save

} // end class
