class SiteService {

    boolean transactional = false

    def sectionService

    def delete(params) {
        Site.withTransaction { status ->
            def result = [:]

            def fail = { Map m ->
                status.setRollbackOnly()
                if(result.siteInstance && m.field)
                    result.siteInstance.errors.rejectValue(m.field, m.code)
                result.error = [ code: m.code, args: ["Site", params.id] ]
                return result
            }

            result.siteInstance = Site.get(params.id)

            if(!result.siteInstance)
                return fail(code:"default.not.found")

            if(result.siteInstance.inventoryStores)
                return fail(code:"inventoryStores.still.associated")

            // Delete sections which in turn deletes assets etc.
            def sections = new ArrayList(result.siteInstance.sections) // avoid ConcurrentModificationException.
            def r
            for(section in sections) {
                result.siteInstance.removeFromSections(section)
                r = sectionService.delete(id: section.id)
                if(r.error) {
                    log.debug r.error
                    fail(code:"site.section.delete.failure")
                    break
                }
            }

            if(result.error)
                return result

            try {
                result.siteInstance.delete(flush:true)
                return result //Success.
            }
            catch(org.springframework.dao.DataIntegrityViolationException e) {
                return fail(code:"default.delete.failure")
            }

        } // end withTransaction
    } // end delete()

} // end class