

<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>Edit AssetSubItem</title>
        <nav:resources override="true"/>
    </head>
    <body>
        <div class="nav">
            <nav:renderSubItems group="navAlt"/>
        </div>
        <div class="body">
            <g:render template="/shared/messages" />
            <g:hasErrors bean="${assetSubItemInstance}">
            <div class="errors">
                <g:renderErrors bean="${assetSubItemInstance}" as="list" />
            </div>
            </g:hasErrors>
            <g:form method="post" >
                <input type="hidden" name="id" value="${assetSubItemInstance?.id}" />
                <input type="hidden" name="version" value="${assetSubItemInstance?.version}" />
                <div class="dialog">
                    <table>
                        <tbody>
                        
                            <tr class="prop">
                                <td valign="top" class="groupHeader">
                                    <label for="name">Asset Sub Item</label>
                                </td>
                                <td valign="top" class="value">
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="groupName">
                                    <label for="name">Name:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:assetSubItemInstance,field:'name','errors')}">
                                    <input type="text" class="description" maxlength="50" id="name" name="name" value="${fieldValue(bean:assetSubItemInstance,field:'name')}"/>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="groupName">
                                    <label for="description">Description:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:assetSubItemInstance,field:'description','errors')}">
                                    <input type="text" class="description" maxlength="75" id="description" name="description" value="${fieldValue(bean:assetSubItemInstance,field:'description')}"/>
                                </td>
                            </tr>
                            
                            <tr class="prop">
                                <td valign="top" class="groupName">
                                    <label for="comment">Comment:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:assetSubItemInstance,field:'comment','errors')}">
                                    <textarea rows="5" cols="40" name="comment">${fieldValue(bean:assetSubItemInstance, field:'comment')}</textarea>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="groupName">
                                    <label for="isActive">Is Active:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:assetSubItemInstance,field:'isActive','errors')}">
                                    <g:checkBox name="isActive" value="${assetSubItemInstance?.isActive}" ></g:checkBox>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="groupHeader">
                                    <label for="name">Extended Attributes</label>
                                </td>
                                <td valign="top" class="value">
                                </td>
                            </tr> 
                        
                            <g:each var="a" in="${assetSubItemInstance?.assetSubItemExtendedAttributes?}">
                                <tr class="prop">
                                    <td valign="top" class="name">
                                    </td>
                                    <td valign="top" class="value ${hasErrors(bean:assetSubItemInstance,field:'assetSubItemExtendedAttributes','errors')}">
                                        <g:link controller="assetSubItemExtendedAttributeDetailed" action="show" id="${a.id}">
                                            ${a?.encodeAsHTML()}
                                        </g:link>
                                    </td>
                                </tr>
                            </g:each>
                        
                            <tr class="prop">
                                <td valign="top" class="groupHeader">
                                </td>
                                <td valign="top" class="value">
                                    <g:link controller="assetSubItemExtendedAttributeDetailed" params="['assetSubItem.id':assetSubItemInstance?.id]" action="create">+Add Extended Attribute</g:link>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                        
                            <tr class="prop">
                                <td valign="top" class="groupHeader">
                                    <label for="name">Asset Tree</label>
                                </td>
                                <td valign="top" class="value">
                                </td>
                            </tr> 

                            <tr class="prop">
                                <td valign="top" class="groupName">Assets:</td>

                                <td  valign="top" style="text-align:left;" class="value">
                                    <g:if test="${assetSubItemInstance.parentItem}" >
                                        N/A (Assigned to parent item)
                                    </g:if>
                                    <g:else>
                                        <g:if test="${assetSubItemInstance.assets}">
                                            <ul>
                                            <g:each var="a" in="${ assetSubItemInstance.assets.sort { p1, p2 -> p1.name.compareToIgnoreCase(p2.name) } }">
                                                <li><g:link controller="assetDetailed" action="show" id="${a.id}">${a?.encodeAsHTML()}</g:link></li>
                                            </g:each>
                                            </ul>
                                        </g:if>
                                        <g:else>
                                            May be assigned via asset edit view.
                                        </g:else>
                                    </g:else>
                                </td>

                            </tr>
                            
                            <tr class="prop">
                                <td valign="top" class="groupName">
                                    <label for="parentItem">Parent Item:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:assetSubItemInstance,field:'parentItem','errors')}">
                                    <g:if test="${assetSubItemInstance.assets}">
                                        Level 1 sub item (Assigned directly to assets)
                                    </g:if>
                                    <g:else>
                                        <g:select optionKey="id" from="${possibleParentItems}" name="parentItem.id" value="${assetSubItemInstance?.parentItem?.id}" noSelection="['null':'--None--']"></g:select>
                                    </g:else>
                                </td>
                            </tr>

                            <tr class="prop">
                                <td valign="top" class="groupName">
                                    <label for="subItems">Sub Items:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:assetSubItemInstance,field:'subItems','errors')}">
                                    
<ul>
<g:each var="s" in="${assetSubItemInstance?.subItems?}">
    <li><g:link controller="assetSubItemDetailed" action="show" id="${s.id}">${s?.encodeAsHTML()}</g:link></li>
</g:each>
</ul>
<g:link controller="assetSubItemDetailed" params="['parentItem.id':assetSubItemInstance?.id]" action="create">+Add Sub Item</g:link>

                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="groupHeader">
                                    <label for="name">Maintenance Actions</label>
                                </td>
                                <td valign="top" class="value">
                                </td>
                            </tr> 
                        
                            <g:each var="m" in="${assetSubItemInstance?.maintenanceActions?}">
                                <tr class="prop">
                                    <td valign="top" class="name">
                                    </td>
                                    <td valign="top" class="value ${hasErrors(bean:assetSubItemInstance,field:'maintenanceActions','errors')}">
                                        <g:link controller="maintenanceActionDetailed" action="show" id="${m.id}">${m?.encodeAsHTML()}</g:link></li>
                                    </td>
                                </tr>
                            </g:each>
                        
                            <tr class="prop">
                                <td valign="top" class="groupHeader">
                                </td>
                                <td valign="top" class="value">
                                    <g:link controller="maintenanceActionDetailed" params="['assetSubItem.id':assetSubItemInstance?.id]" action="create">+Add Maintenance Action</g:link>
                                </td>
                            </tr> 
                        
                        </tbody>
                    </table>
                </div>
                <div class="buttons">
                    <span class="button"><g:actionSubmit class="save" value="Update" /></span>
                    <span class="button"><g:actionSubmit class="cancel" value="Cancel" action="Show"/></span>
                    <span class="button"><g:actionSubmit class="delete" onclick="return confirm('Are you sure?');" value="Delete" /></span>
                </div>
            </g:form>
        </div>
    </body>
</html>
