import org.codehaus.groovy.grails.commons.*

/**
* Provides a quartz job that reindex's the Lucene index for the Inventory domain class.
* With concurrent=false the repeat interval starts after the previous job completes.
* We need a hibernate session otherwise we get a LazyInitializationException, default is true but we specify it to be sure.
*/
class InventoryReindexJob {

    def concurrent = false
    def sessionRequired = true

    static triggers = {
        // Cron fields:
        // 'Seconds Minutes Hours DOM Month DOW Year(Optional)'
        // See: http://www.quartz-scheduler.org/docs/tutorials/crontrigger.html
        // Trigger every hour on the hour:
        cron name: 'RebuildInventoryIndex', cronExpression: "0 0 * * * ?"
    }

    def execute() {

        // Some information can be accessed if we run with "def execute(context) ".
        // For more info see: http://quartz.sourceforge.net/javadoc/org/quartz/JobExecutionContext.html
        // log.debug context.getTrigger()
        // log.debug context.getPreviousFireTime()
        // log.debug context.getFireTime()

        // Reindex the Inventory domain class.
        log.info "Rebuilding Lucene index, Inventory.reindex()."
        InventoryItem.reindex()
        log.info "Rebuilding Lucene index, complete."
    }
}
