<html>
    <head>
        <meta name="layout" content="main" />
        <title>Edit Picture</title>
        <nav:resources override="true"/>
        <g:render template="/shared/pictureHead" />
    </head>
    <body>
        <div class="nav">
            <h1>Edit Picture</h1>
        </div>
        <div class="body">
            <g:render template="/shared/messages" />
            <g:hasErrors bean="${picture}">
                <div class="errors">
                    <g:renderErrors bean="${picture}" as="list" />
                </div>
            </g:hasErrors>
            <g:form method="post" onsubmit="return Lightbox.loading();">
                <input type="hidden" name="id" value="${picture?.id}" />
                <div class="dialog">
                    <table>
                        <tbody>
                            <tr class="prop">
                                <td valign="top" class="name">Picture:</td>
                                <td valign="top" class="value">
                                    <span class='gallery'><wa:pictureLightboxAnchor picture="${picture}" size="${Image.Medium}" lightboxSize="${Image.Large}" title="Slide Show" /></span>
                                </td>
                            </tr>
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="operation">Operation:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean: picture, field: 'operation', 'errors')}">
                                    <select id="operation" name="operation">
                                        <option value="${Picture.NoOp}" selected="selected">None</option>
                                        <option value="${Picture.RotateClockWise90}">Rotate clockwise 90 degrees</option>
                                        <option value="${Picture.RotateAntiClockWise90}">Rotate anti-clockwise 90 degrees</option>
                                        <option value="${Picture.Rotate180}">Rotate 180 degrees</option>
                                        <option value="${Picture.Flip}">Vertical mirror image</option>
                                        <option value="${Picture.Flop}">Horizontal mirror image</option>
                                    </select>
                                </td>
                            </tr>
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="inventoryItem.id">Inventory Item:</label>
                                </td>
                                <td valign="top" class="value">
                                    <g:link controller="inventoryItemDetailed" action="show" id="${picture.inventoryItem?.id}" title="Show Inventory Item">
                                        ${picture.inventoryItem?.toString()?.encodeAsHTML()}
                                    </g:link>
                                </td>
                            </tr>
                            </tr>
                        </tbody>
                    </table>
                </div>
                <div class="buttons">
                    <span class="button"><g:actionSubmit class="save" value="Update" /></span>
                    <span class="button"><g:actionSubmit class="delete" onclick="return confirm('Are you sure?');" value="Delete" /></span>
                </div>
            </g:form>
        </div>
    </body>
</html>
