class Task {

    TaskGroup taskGroup
    TaskStatus taskStatus
    TaskPriority taskPriority
    TaskBudgetStatus taskBudgetStatus
    TaskType taskType
    Task parentTask
    Person leadPerson
    Site site
    Section section
    Asset primaryAsset
    AssetSubItem assetSubItem
    TaskRecurringSchedule taskRecurringSchedule
    TaskProcedure taskProcedure

    String description
    String comment = ""
    Date targetStartDate = new Date()
    Date targetCompletionDate = new Date()
    boolean approved = false
    boolean trash = false
    boolean attentionFlag = false
    boolean safetyRequirement = false
    boolean mandatoryRegulatory = false
    boolean positiveFault = false

    static hasMany = [entries: Entry,
                        taskModifications: TaskModification,
                        assignedGroups: AssignedGroup,
                        assignedPersons: AssignedPerson,
                        subTasks: Task,
                        associatedAssets: Asset,
                        inventoryMovements: InventoryMovement]

    static mappedBy = [taskRecurringSchedule:"task"]

    static belongsTo = [TaskGroup, TaskStatus, Task, Person]

    static constraints = {
        description(blank:false,maxSize:75)
        comment(maxSize:1000)
        targetStartDate()
        targetCompletionDate(validator: {val, obj ->
            if(val.before(obj.targetStartDate))
                return 'before.targetStartDate'
        })
        leadPerson()
        taskPriority()
        taskBudgetStatus()
        taskStatus()
        parentTask(nullable:true)
        site(nullable:true)
        section(nullable:true)
        primaryAsset(nullable:true)
        assetSubItem(nullable:true)
        taskRecurringSchedule(nullable:true)
        taskProcedure(nullable:true)

    }

    String toString() {"${this.id} - ${this.description}"}
}
