

<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>Show InventoryItemPurchase</title>
    </head>
    <body>
        <div class="nav">
            <h1>Show InventoryItemPurchase</h1>
        </div>
        <div class="body">
            <g:render template="/shared/messages" />
            <div class="dialog">
                <table>
                    <tbody>
                    
                        <tr class="prop">
                            <td valign="top" class="name">Inventory Item:</td>
                            
                            <td valign="top" class="value"><g:link controller="inventoryItemDetailed" action="show" id="${inventoryItemPurchaseInstance?.inventoryItem?.id}">${inventoryItemPurchaseInstance?.inventoryItem?.encodeAsHTML()}</g:link></td>
                            
                        </tr>
                    
                        <tr class="prop">
                            <td valign="top" class="name">Inventory Item Purchase Type:</td>
                            
                            <td valign="top" class="value">${inventoryItemPurchaseInstance?.inventoryItemPurchaseType?.encodeAsHTML()}</td>
                            
                        </tr>
                    
                        <tr class="prop">
                            <td valign="top" class="name">Purchase Order Number:</td>
                            
                            <td valign="top" class="value">${fieldValue(bean:inventoryItemPurchaseInstance, field:'purchaseOrderNumber')}</td>
                            
                        </tr>
                    
                        <tr class="prop">
                            <td valign="top" class="name">Cost Code:</td>
                            
                            <td valign="top" class="value"><g:link controller="costCodeDetailed" action="show" id="${inventoryItemPurchaseInstance?.costCode?.id}">${inventoryItemPurchaseInstance?.costCode?.encodeAsHTML()}</g:link></td>
                            
                        </tr>
                    
                        <tr class="prop">
                            <td valign="top" class="name">Quantity:</td>
                            
                            <td valign="top" class="value">${fieldValue(bean:inventoryItemPurchaseInstance, field:'quantity')}</td>
                            
                        </tr>
                    
                        <tr class="prop">
                            <td valign="top" class="name">Order Value:</td>
                            
                            <td valign="top" class="value">
                                ${fieldValue(bean:inventoryItemPurchaseInstance, field:'orderValueAmount')}
                                ${inventoryItemPurchaseInstance.orderValueCurrency?.encodeAsHTML()}
                            </td>
                            
                        </tr>
                    
                        <tr class="prop">
                            <td valign="top" class="name">Invoice Number:</td>
                            
                            <td valign="top" class="value">${fieldValue(bean:inventoryItemPurchaseInstance, field:'invoiceNumber')}</td>
                            
                        </tr>
                        
                        <tr class="prop">
                            <td valign="top" class="name">
                                <label for="receivedComplete">Received Complete:</label>
                            </td>
                            <td valign="top" class="value">
                                ${inventoryItemPurchaseInstance?.receivedComplete}
                            </td>
                        </tr>
                        
                        <tr class="prop">
                            <td valign="top" class="name">
                                <label for="invoicePaymentApproved">Invoice Payment Approved:</label>
                            </td>
                            <td valign="top" class="value">
                                ${inventoryItemPurchaseInstance?.invoicePaymentApproved}
                            </td>
                        </tr>
                    
                        <tr class="prop">
                            <td valign="top" class="name">Date Entered:</td>
                            
                            <td valign="top" class="value">
                                <g:formatDate date="${inventoryItemPurchaseInstance?.dateEntered}" format="EEE, dd-MMM-yyyy @ HH:mm"/>
                            </td>
                            
                        </tr>
                    
                        <tr class="prop">
                            <td valign="top" class="name">Entered By:</td>
                            
                            <td valign="top" class="value"><g:link controller="person" action="show" id="${inventoryItemPurchaseInstance?.enteredBy?.id}">${inventoryItemPurchaseInstance?.enteredBy?.encodeAsHTML()}</g:link></td>
                            
                        </tr>
                    
                    </tbody>
                </table>
            </div>
            <div class="buttons">
                <g:form>
                    <input type="hidden" name="id" value="${inventoryItemPurchaseInstance?.id}" />
                    <span class="button"><g:actionSubmit class="edit" value="Edit" /></span>
                    <span class="button"><g:actionSubmit class="delete" onclick="return confirm('Are you sure?');" value="Delete" /></span>
                </g:form>
            </div>
        </div>
    </body>
</html>
