class PersonGroupController extends BaseController {

    def beforeInterceptor = [action:this.&auth]

    def index = { redirect(action:list,params:params) }

    // the delete, save and update actions only accept POST requests
    def allowedMethods = [delete:'POST', save:'POST', update:'POST']

    def list = {
        if(!params.max) params.max = 10
        [ personGroupInstanceList: PersonGroup.list( params ) ]
    }

    def show = {
        def personGroupInstance = PersonGroup.get( params.id )

        if(!personGroupInstance) {
            flash.message = "PersonGroup not found with id ${params.id}"
            redirect(action:list)
        }
        else { return [ personGroupInstance : personGroupInstance ] }
    }

    def delete = {
        def personGroupInstance = PersonGroup.get( params.id )
        if(personGroupInstance) {
            personGroupInstance.delete()
            flash.message = "PersonGroup ${params.id} deleted"
            redirect(action:list)
        }
        else {
            flash.message = "PersonGroup not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def edit = {
        def personGroupInstance = PersonGroup.get( params.id )

        if(!personGroupInstance) {
            flash.message = "PersonGroup not found with id ${params.id}"
            redirect(action:list)
        }
        else {
            return [ personGroupInstance : personGroupInstance ]
        }
    }

    def update = {
        def personGroupInstance = PersonGroup.get( params.id )
        if(personGroupInstance) {
            personGroupInstance.properties = params
            if(!personGroupInstance.hasErrors() && personGroupInstance.save()) {
                flash.message = "PersonGroup ${params.id} updated"
                redirect(action:show,id:personGroupInstance.id)
            }
            else {
                render(view:'edit',model:[personGroupInstance:personGroupInstance])
            }
        }
        else {
            flash.message = "PersonGroup not found with id ${params.id}"
            redirect(action:edit,id:params.id)
        }
    }

    def create = {
        def personGroupInstance = new PersonGroup()
        personGroupInstance.properties = params
        return ['personGroupInstance':personGroupInstance]
    }

    def save = {
        def personGroupInstance = new PersonGroup(params)
        if(!personGroupInstance.hasErrors() && personGroupInstance.save()) {
            flash.message = "PersonGroup ${personGroupInstance.id} created"
            redirect(action:show,id:personGroupInstance.id)
        }
        else {
            render(view:'create',model:[personGroupInstance:personGroupInstance])
        }
    }
}
