import grails.test.*

/**
* Unit tests for AppConfigService class.
*/
class AppConfigServiceTests extends GrailsUnitTestCase {

    // Not automatically injected, assignment is bellow.
    def appConfigService

    // Some test data.
    def configName01 = "baseDataCreated"
    def configName02 = "dateFormat"
    def configName03 = "blankValue"
    def blankString = ''
    def configDefaultValue = "true"
    def configValue01 = "false"
    def configValue02= "EEE, dd-MMM-yyyy"

    protected void setUp() {
        super.setUp()

        // Mock the domain class.
        mockDomain(AppConfig)
        mockForConstraintsTests(AppConfig)

        // Mock logging with debug enabled/disabled.
        mockLogging(AppConfigService, true)

        // Get an instance of the service.
        appConfigService = new AppConfigService()
    }

    protected void tearDown() {
        super.tearDown()
    }

    void testSet() {

        // Set returns false for blank name.
        assert AppConfig.list().size == 0
        assertFalse appConfigService.set(blankString)
        assert AppConfig.list().size == 0

        // Set returns true and saves an object.
        assertTrue appConfigService.set(configName01)
        assert AppConfig.list().size == 1

        // Set returns true and does not save a new object for existing appConfig.
        assertTrue appConfigService.set(configName01, configValue01)
        assert AppConfig.list().size == 1

        // Set returns true and saves different objects.
        assertTrue appConfigService.set(configName02, configValue02)
        assert AppConfig.list().size == 2

        // Set returns false when trying to set a blank value.
        assertFalse appConfigService.set(configName03, blankString)
        assert AppConfig.list().size == 2
    }

    void testExists() {

        // Exists returns false for non existant appConfig.
        assertFalse appConfigService.exists(configName01)

        // Exists returns true for existing appConfig.
        appConfigService.set(configName01)
        assertTrue appConfigService.exists(configName01)
    }

    void testGetValue() {

        // Get returns false for non existant appConfig.
        assertFalse appConfigService.getValue(configName01)

        // Set default and check that it returns.
        appConfigService.set(configName01)
        assert appConfigService.getValue(configName01) == configDefaultValue

        // Set a value and check that it returns.
        appConfigService.set(configName01, configValue01)
        assert appConfigService.getValue(configName01) == configValue01
    }

    void testDelete() {

        // Deleting returns false for non existant appConfig.
        assert AppConfig.list().size == 0
        assertFalse appConfigService.delete(configName01)

        // First set.
        appConfigService.set(configName01)
        assert AppConfig.list().size == 1

        // Second set.
        appConfigService.set(configName02, configValue02)
        assert AppConfig.list().size == 2

        // Delete first set.
        assertTrue appConfigService.delete(configName01)
        assert AppConfig.list().size == 1

        // Delete second set.
        assertTrue appConfigService.delete(configName02)
        assert AppConfig.list().size == 0
    }

}
