

<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>AssetSubItem Search</title>
        <nav:resources override="true"/>
        <filterpane:includes />
        <export:resource />
    </head>
    <body>
        <div class="nav">
            <nav:renderSubItems group="navAlt"/>
        </div>
        <div class="body">
            <g:render template="/shared/messages" />

            <filterpane:currentCriteria domainBean="AssetSubItem"
                                    action="search"
                                    dateFormat="EEE, dd-MMM-yyyy"
                                    removeImgDir="images" 
                                    removeImgFile="bullet_delete.png"
                                    title="Search"/>

            <div class="paginateButtons">
                Results: ${assetSubItemInstanceList.size()} / ${assetSubItemInstanceTotal}
                <span class="searchButtons">
                    <filterpane:filterButton text="Search" appliedText="Change Search" />
                </span>
            </div>

            <jsUtil:toggleControl toggleId="options"
                                                    imageId="optionsImg"
                                                    closedImgUrl="${resource(dir:'images/skin',file:'bullet_arrow_right.png')}"
                                                    openImgUrl="${resource(dir:'images/skin',file:'bullet_arrow_down.png')}"
                                                    text="${g.message(code: 'default.options.text')}"
                                                    />

            <div id="options" style="display:none;">
                <g:form method="post">
                    <g:hiddenField name="params" value="${filterParams}" />
                    <div class="dialog">
                        <table>
                            <tbody>

                                <tr class="prop">
                                    <td valign="top" class="name">
                                        <label for="max">Results per page:</label>
                                    </td>
                                    <td valign="top" class="value">
                                        <input type="text" maxlength="4" id="description" name="newMax" value="${params.max}"/>

                                        <span class="buttons">
                                            <g:actionSubmit action="setSearchParamsMax" class="go" value="Update" />
                                        </span>
                                    </td>
                                </tr>

                            </tbody>
                        </table>
                    </div>
                </g:form>
                <export:formats  params="${filterParams}" formats="['csv', 'excel', 'pdf', 'rtf']"/>
            </div>

            <br />

            <g:if test="${assetSubItemInstanceList.size() > 10}">
                <g:if test="${assetSubItemInstanceTotal > assetSubItemInstanceList.size()}">
                    <div class="paginateButtons">
                        <g:paginate total="${assetSubItemInstanceTotal}" params="${filterParams}" />
                    </div>
                </g:if>
            </g:if>

            <g:if test="${assetSubItemInstanceList.size() > 0}">
                <div class="list">
                    <table>
                        <thead>
                            <tr>
                            
                                <g:sortableColumn property="id" title="Id" params="${filterParams}" />

                                <g:sortableColumn property="name" title="Name" params="${filterParams}" />
                            
                                <g:sortableColumn property="description" title="Description" params="${filterParams}" />

                                <g:sortableColumn property="isActive" title="Is Active" params="${filterParams}" />

                                <th></th>
                            
                            </tr>
                        </thead>
                        <tbody>
                        <g:each in="${assetSubItemInstanceList}" status="i" var="assetSubItemInstance">
                            <tr class="${(i % 2) == 0 ? 'clickableOdd' : 'clickableEven'}"/>
                            
                                <td onclick='window.location = "${request.getContextPath()}/assetSubItemDetailed/show/${assetSubItemInstance.id}"'>
                                    ${fieldValue(bean:assetSubItemInstance, field:'id')}
                                </td>

                                <td onclick='window.location = "${request.getContextPath()}/assetSubItemDetailed/show/${assetSubItemInstance.id}"'>
                                    ${fieldValue(bean:assetSubItemInstance, field:'name')}
                                </td>

                                <td onclick='window.location = "${request.getContextPath()}/assetSubItemDetailed/show/${assetSubItemInstance.id}"'>
                                    ${fieldValue(bean:assetSubItemInstance, field:'description')}
                                </td>

                                <td onclick='window.location = "${request.getContextPath()}/assetSubItemDetailed/show/${assetSubItemInstance.id}"'>
                                    ${fieldValue(bean:assetSubItemInstance, field:'isActive')}
                                </td>

                                <td class="notClickable">
                                    <g:link action="show" id="${assetSubItemInstance.id}">
                                        <img  src="${resource(dir:'images/skin',file:'database_go.png')}" alt="Show" />
                                    </g:link>
                                </td>
                            
                            </tr>
                        </g:each>
                        </tbody>
                    </table>
                </div>
            </g:if>
            <div class="paginateButtons">
                <g:paginate total="${assetSubItemInstanceTotal}" params="${filterParams}" />
            </div>

            <filterpane:filterPane domainBean="AssetSubItem"
                                    title="Search"
                                    action="search"
                                    class="overlayPane"
                                    excludeProperties="" />
        </div> <!-- end body div -->
    </body>
</html>
