import grails.util.GrailsUtil

class BootStrap 
{
    def init = { servletContext ->

    println "**** BootStrap GrailsUtil.environment = ${GrailsUtil.environment}"
    
        switch (GrailsUtil.environment)
        {
            case "development":
                        bootStrapDemoData()
                        break
            case "test":
                        break
            case "production":
                        bootStrapDemoData()
                        break 
        }
    
    }

    def destroy = {
    }

    //Insert some demo/startup data.
    void bootStrapDemoData()
    {
        println "BootStrapping demo data..."
    
        //TypeOfPersonGroup
        new PersonGroupType(name:"Department").save()
        new PersonGroupType(name:"Contractor").save()
        new PersonGroupType(name:"ProjectTeam").save()
    
        //PersonGroup
        new PersonGroup(personGroupType:PersonGroupType.findByName("Department"),
                        name:"Electrical").save()
        new PersonGroup(personGroupType:PersonGroupType.get(2),
                        name:"Kewl AirCon Guys").save()
        new PersonGroup(personGroupType:PersonGroupType.get(3),
                        name:"gnuMims").save()
            
        //Person
        new Person(personGroup:PersonGroup.get(3),
            firstName:"Admin",
            lastName:"Powers",
            userId:"admin",
            password:"pass").save()
        new Person(personGroup:PersonGroup.get(1),
            firstName:"Demo",
            lastName:"Danza",
            userId:"user",
            password:"pass").save()
        new Person(personGroup:PersonGroup.get(1),
            firstName:"Craig",
            lastName:"SuperTech",
            userId:"craig",
            password:"pass").save()
        new Person(personGroup:PersonGroup.get(2),
            firstName:"Joe",
            lastName:"Samples",
            userId:"joe",
            password:"pass").save()
        new Person(personGroup:PersonGroup.get(1),
            firstName:"Production",
            lastName:"Mann",
            userId:"Mann",
            password:"pass").save()
                
        //TaskGroup
        new TaskGroup(name:"Engineering",
                      description:"Engineering task group").save()
        new TaskGroup(name:"Production",
                      description:"Production task group").save()
        new TaskGroup(name:"NewProject(s)",
                      description:" ").save()
                      
        
        //Task
        new Task(taskGroup:TaskGroup.findByName("Engineering"),
                 leadPerson:Person.get(3),
                 name:"Check specific level sensor",
                 description:"Has been noted as problematic, try recallibrating",
                 scheduledDate: new Date(),
                 targetDate: new Date() ).save()
        new Task(taskGroup:TaskGroup.findByName("Production"),
                 leadPerson:Person.get(5),
                 name:"Production Report",
                 description:"Production report for specific production run or shift",
                 scheduledDate: new Date(),
                 targetDate: new Date() ).save()
        new Task(taskGroup:TaskGroup.findByName("NewProject(s)"),
                 leadPerson:Person.get(1),
                 name:"Make killer CMMS app",
                 description:"Use Grails and get a move on!",
                 scheduledDate: new Date(),
                 targetDate: new Date() ).save()

        //EntryType
        new EntryType(name:"Fault").save()
        new EntryType(name:"WorkDone").save()
        new EntryType(name:"Production Report").save()

        //ModificationType
        new ModificationType(name:"Created").save()
        new ModificationType(name:"Completed").save()
        new ModificationType(name:"Closed").save()
        new ModificationType(name:"Altered").save()
        new ModificationType(name:"TargetDateModified").save()
        new ModificationType(name:"ScheduledDateModified").save()
        new ModificationType(name:"DescriptionModified").save()
        new ModificationType(name:"AssignedToModified").save()
        new ModificationType(name:"NameModified").save()
        
        println "BootStrapping demo data...completed."
    
    }

}
