import org.codehaus.groovy.grails.plugins.springsecurity.Secured

@Secured(['ROLE_AppAdmin', 'ROLE_Manager', 'ROLE_InventoryManager'])
class InventoryStoreDetailedController extends BaseController {
    
    @Secured(['ROLE_AppAdmin', 'ROLE_Manager', 'ROLE_InventoryManager', 'ROLE_InventoryUser'])
    def index = { redirect(action:list,params:params) }

    // the delete, save and update actions only accept POST requests
    static allowedMethods = [delete:'POST', save:'POST', update:'POST']

    def list = {
        params.max = Math.min( params.max ? params.max.toInteger() : 10,  100)
        [ inventoryStoreInstanceList: InventoryStore.list( params ), inventoryStoreInstanceTotal: InventoryStore.count() ]
    }

    @Secured(['ROLE_AppAdmin', 'ROLE_Manager', 'ROLE_InventoryManager', 'ROLE_InventoryUser'])
    def show = {

        // In the case of an actionSubmit button, rewrite action name from 'index'.
        if(params._action_Show)
            params.action='show'

        def inventoryStoreInstance = InventoryStore.get( params.id )

        if(!inventoryStoreInstance) {
            flash.message = "InventoryStore not found with id ${params.id}"
            redirect(action:list)
        }
        else { return [ inventoryStoreInstance : inventoryStoreInstance ] }
    }

    def delete = {
        def inventoryStoreInstance = InventoryStore.get( params.id )
        if(inventoryStoreInstance) {
            try {
                inventoryStoreInstance.delete(flush:true)
                flash.message = "InventoryStore ${params.id} deleted"
                redirect(action:list)
            }
            catch(org.springframework.dao.DataIntegrityViolationException e) {
                flash.message = "InventoryStore ${params.id} could not be deleted"
                redirect(action:show,id:params.id)
            }
        }
        else {
            flash.message = "InventoryStore not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def edit = {

        // In the case of an actionSubmit button, rewrite action name from 'index'.
        if(params._action_Edit)
            params.action='edit'

        def inventoryStoreInstance = InventoryStore.get( params.id )

        if(!inventoryStoreInstance) {
            flash.message = "InventoryStore not found with id ${params.id}"
            redirect(action:list)
        }
        else {
            return [ inventoryStoreInstance : inventoryStoreInstance ]
        }
    }

    def update = {
        def inventoryStoreInstance = InventoryStore.get( params.id )
        if(inventoryStoreInstance) {
            if(params.version) {
                def version = params.version.toLong()
                if(inventoryStoreInstance.version > version) {
                    
                    inventoryStoreInstance.errors.rejectValue("version", "default.optimistic.locking.failure")
                    render(view:'edit',model:[inventoryStoreInstance:inventoryStoreInstance])
                    return
                }
            }
            inventoryStoreInstance.properties = params
            if(!inventoryStoreInstance.hasErrors() && inventoryStoreInstance.save(flush: true)) {
                flash.message = "InventoryStore ${params.id} updated"
                redirect(action:show,id:inventoryStoreInstance.id)
            }
            else {
                render(view:'edit',model:[inventoryStoreInstance:inventoryStoreInstance])
            }
        }
        else {
            flash.message = "InventoryStore not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def create = {
        def inventoryStoreInstance = new InventoryStore()
        inventoryStoreInstance.properties = params
        return ['inventoryStoreInstance':inventoryStoreInstance]
    }

    def save = {
        def inventoryStoreInstance = new InventoryStore(params)
        if(!inventoryStoreInstance.hasErrors() && inventoryStoreInstance.save(flush: true)) {
            flash.message = "InventoryStore ${inventoryStoreInstance.id} created"
            redirect(action:show,id:inventoryStoreInstance.id)
        }
        else {
            render(view:'create',model:[inventoryStoreInstance:inventoryStoreInstance])
        }
    }
}
