

<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>InventoryItem Search</title>
        <nav:resources override="true"/>
        <g:render template="/shared/pictureHead" />
        <filterpane:includes />
        <export:resource />
    </head>
    <body>
        <div class="nav">
            <nav:renderSubItems group="nav"/>
        </div>
        <div class="body">
            <g:render template="/shared/messages" />
            <filterpane:currentCriteria domainBean="InventoryItem"
                                    action="search"
                                    dateFormat="EEE, dd-MMM-yyyy"
                                    removeImgDir="images" 
                                    removeImgFile="bullet_delete.png"
                                    title="Search"/>

            <div class="paginateButtons">
                <span class="searchButtons">
                    <a href='' onclick="showElement('searchPane'); return false;">Quick</a>
                </span>
                Results: ${inventoryItemInstanceList.size()} / ${inventoryItemInstanceTotal}
                <span class="searchButtons">
                    <filterpane:filterButton text="Search" appliedText="Change Search" />
                </span>
            </div>

            <jsUtil:toggleControl toggleId="options"
                                                    imageId="optionsImg"
                                                    closedImgUrl="${resource(dir:'images/skin',file:'bullet_arrow_right.png')}"
                                                    openImgUrl="${resource(dir:'images/skin',file:'bullet_arrow_down.png')}"
                                                    text="${g.message(code: 'default.options.text')}"
                                                    />

            <div id="options" style="display:none;">
                <g:form method="post" >
                    <g:hiddenField name="params" value="${filterParams}" />
                    <div class="dialog">
                        <table>
                            <tbody>

                                <tr class="prop">
                                    <td valign="top" class="name">
                                        <label for="max">Results per page:</label>
                                    </td>
                                    <td valign="top" class="value">
                                        <input type="text" maxlength="4" id="description" name="newMax" value="${params.max}"/>

                                        <span class="buttons">
                                            <g:actionSubmit action="setSearchParamsMax" class="go" value="Update" />
                                        </span>
                                    </td>
                                </tr>

                                <tr class="prop">
                                    <td valign="top" class="name">
                                        <label for="max">Inventory:</label>
                                    </td>
                                    <td valign="top" class="value">
                                        <g:link action="exportInventory">
                                            Export
                                        </g:link>
                                        /
                                        <g:link action="exportInventoryTemplate">
                                            Template
                                        </g:link>
                                        /
                                        <g:link action="exportInventoryExample">
                                            Example
                                        </g:link>
                                        /
                                        <g:link action="importInventory">
                                            Import Inventory
                                        </g:link>
                                        /
                                        <g:link action="importInventoryItemPurchases">
                                            Import Purchases
                                        </g:link>
                                    </td>
                                </tr>

                            </tbody>
                        </table>
                    </div>
                </g:form>
                <export:formats  params="${filterParams}" formats="['csv', 'excel', 'pdf', 'rtf']"/>
            </div>

            <br />

            <g:if test="${inventoryItemInstanceList.size() > 10}">
                <g:if test="${inventoryItemInstanceTotal > inventoryItemInstanceList.size()}">
                    <div class="paginateButtons">
                        <g:paginate total="${inventoryItemInstanceTotal}" params="${filterParams}" />
                    </div>
                </g:if>
            </g:if>

            <g:if test="${inventoryItemInstanceList.size() > 0}">
                <div class="list">
                    <table>
                        <thead>
                            <tr>

                                <th>Picture</th>
                            
                                <g:sortableColumn property="name" title="Name" params="${filterParams}" />
                            
                                <g:sortableColumn property="description" title="Description" params="${filterParams}" />
                            
                                <g:sortableColumn property="unitsInStock" title="Units In Stock" params="${filterParams}" />
                                
                                <th>Unit Of Measure</th>

                                <th></th>
                            
                            </tr>
                        </thead>
                        <tbody>
                        <g:each in="${inventoryItemInstanceList}" status="i" var="inventoryItemInstance">
                            <tr class="${(i % 2) == 0 ? 'clickableOdd' : 'clickableEven'}" />

                                <td class='gallery'>
                                    <g:if test="${inventoryItemInstance.picture}" >
                                        <wa:pictureLightboxAnchor picture="${inventoryItemInstance.picture}"
                                                                                            size="${Image.Small}"
                                                                                            lightboxSize="${Image.Large}"
                                                                                            target="_blank"
                                                                                            title="Show Original" />
                                    </g:if>
                                </td>
                            
                                <td onclick='window.location = "${request.getContextPath()}/inventoryItemDetailed/show/${inventoryItemInstance.id}"' >
                                    ${fieldValue(bean:inventoryItemInstance, field:'name')}
                                </td>
                            
                                <td onclick='window.location = "${request.getContextPath()}/inventoryItemDetailed/show/${inventoryItemInstance.id}"' >
                                    ${fieldValue(bean:inventoryItemInstance, field:'description')}
                                </td>
                            
                                <td onclick='window.location = "${request.getContextPath()}/inventoryItemDetailed/show/${inventoryItemInstance.id}"' >
                                    ${fieldValue(bean:inventoryItemInstance, field:'unitsInStock')}
                                </td>
                            
                                <td onclick='window.location = "${request.getContextPath()}/inventoryItemDetailed/show/${inventoryItemInstance.id}"' >
                                    ${fieldValue(bean:inventoryItemInstance, field:'unitOfMeasure')}
                                </td>

                                <td>
                                    <g:link action="show" id="${inventoryItemInstance.id}">
                                        <img  src="${resource(dir:'images/skin',file:'database_go.png')}" alt="Show" />
                                    </g:link>
                                </td>
                            
                            </tr>
                        </g:each>
                        </tbody>
                    </table>
                </div>
            </g:if>
            <div class="paginateButtons">
                <g:paginate total="${inventoryItemInstanceTotal}" params="${filterParams}" />
            </div>

            <filterpane:filterPane domainBean="InventoryItem"
                                    title="Search"
                                    action="search"
                                    class="overlayPane"
                                    excludeProperties="estimatedUnitPriceCurrency,
                                                                    averageDeliveryTime"
                                    associatedProperties="inventoryLocation.name,
                                                                            spareFor.name,
                                                                            preferredManufacturer.name,
                                                                            preferredSupplier.name"
                                    filterPropertyValues="${['inventoryLocation.name':[values:InventoryLocation.list()],
                                                                                'spareFor.name':[values:Asset.list()],
                                                                                'preferredManufacturer.name':[values:Manufacturer.findAllByIsActive(true)],
                                                                                'preferredSupplier.name':[values:Supplier.findAllByIsActive(true)],
                                                                                ]}"/>
        </div> <!-- end body div -->

        <!-- Start Search Pane -->
        <div class="overlayPane" id="searchPane" style="display:none;">
            <h2>Quick Search</h2>
            <g:form method="post" id="searchForm" name="searchForm" >
                <table>
                    <tbody>

                        <tr class="prop">
                            <td valign="top" class="name">
                                <label>Inventory:</label>
                            </td>
                            <td valign="top" class="value">
                                <g:link controller="inventoryItemDetailed"
                                                action="search"
                                                params="[quickSearch: 'all']">
                                                <g:message code="default.all.text" />
                                </g:link>
                                <br />
                                <g:link controller="inventoryItemDetailed"
                                                action="search"
                                                params="[quickSearch: 'inventoryBelowReorder']">
                                                <g:message code="inventoryItem.search.text.below.reorder" />
                                </g:link> - <g:message code="inventoryItem.search.text.below.reorder.description" />
                                <br />
                                <g:link controller="inventoryItemDetailed"
                                                action="search"
                                                params="[quickSearch: 'inventoryBelowReorderAll']">
                                                <g:message code="inventoryItem.search.text.below.reorder.all" />
                                </g:link> - <g:message code="inventoryItem.search.text.below.reorder.all.description" />
                                <br />
                                <g:link controller="inventoryItemDetailed"
                                                action="search"
                                                params="[quickSearch: 'recentlyUsed', daysBack: '14']">
                                                <g:message code="inventoryItem.search.text.recently.used" />
                                </g:link> - <g:message code="inventoryItem.search.text.recently.used.description" args="[14]"/>
                                <br />
                                <g:link controller="inventoryItemDetailed"
                                                action="search"
                                                params="[quickSearch: 'recentlyUsed', daysBack: '30']">
                                                <g:message code="inventoryItem.search.text.recently.used" />
                                </g:link> - <g:message code="inventoryItem.search.text.recently.used.description" args="[30]"/>
                            </td>
                        </tr>

                        <tr class="prop">
                            <td valign="top" class="name">
                                <label>Links:</label>
                            </td>
                            <td valign="top" class="value">
                                <g:link controller="inventoryItemPurchaseDetailed"
                                                action="search">
                                                Purchases
                                </g:link>
                            </td>
                        </tr>

                    </tbody>
                </table>
                <div class="buttons">
                    <span class="button">
                        <input type="button" value="${g.message(code:'fp.tag.filterPane.button.cancel.text', default:'Cancel')}" onclick="return hideElement('searchPane');" />
                    </span>
                </div>
            </g:form>
        </div> <!-- end search pane -->

    </body>
</html>
