

<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>Asset Search</title>
        <nav:resources override="true"/>
        <filterpane:includes />
        <export:resource />
    </head>
    <body>
        <div class="nav">
            <nav:renderSubItems group="nav"/>
        </div>
        <div class="body">
            <g:render template="/shared/messages" />

            <filterpane:currentCriteria domainBean="Asset"
                                    action="search"
                                    dateFormat="EEE, dd-MMM-yyyy"
                                    removeImgDir="images" 
                                    removeImgFile="bullet_delete.png"
                                    title="Search"/>

            <div class="paginateButtons">
                Results: ${assetInstanceList.size()} / ${assetInstanceTotal}
                <span class="searchButtons">
                    <filterpane:filterButton text="Search" appliedText="Change Search" />
                </span>
            </div>

            <jsUtil:toggleControl toggleId="options"
                                                    imageId="optionsImg"
                                                    closedImgUrl="${resource(dir:'images/skin',file:'bullet_arrow_right.png')}"
                                                    openImgUrl="${resource(dir:'images/skin',file:'bullet_arrow_down.png')}"
                                                    text="${g.message(code: 'default.options.text')}"
                                                    />

            <div id="options" style="display:none;">
                <g:form method="post" >
                    <g:hiddenField name="params" value="${filterParams}" />
                    <div class="dialog">
                        <table>
                            <tbody>

                                <tr class="prop">
                                    <td valign="top" class="name">
                                        <label for="max">Results per page:</label>
                                    </td>
                                    <td valign="top" class="value">
                                        <input type="text" maxlength="4" id="description" name="newMax" value="${params.max}"/>

                                        <span class="buttons">
                                            <g:actionSubmit action="setSearchParamsMax" class="go" value="Update" />
                                        </span>
                                    </td>
                                </tr>

                                <tr class="prop">
                                    <td valign="top" class="name">
                                        <label for="max">Asset Tree:</label>
                                    </td>
                                    <td valign="top" class="value">
                                        <g:link action="exportAssetTree">
                                            Export
                                        </g:link>
                                        /
                                        <g:link action="exportAssetTreeTemplate">
                                            Template
                                        </g:link>
                                        /
                                        <g:link action="importAssetTree">
                                            Import
                                        </g:link>
                                    </td>
                                </tr>

                            </tbody>
                        </table>
                    </div>
                </g:form>
                <export:formats  params="${filterParams}" formats="['csv', 'excel', 'pdf', 'rtf']"/>
            </div>

            <br />

            <g:if test="${assetInstanceList.size() > 10}">
                <g:if test="${assetInstanceTotal > assetInstanceList.size()}">
                    <div class="paginateButtons">
                        <g:paginate total="${assetInstanceTotal}" params="${filterParams}" />
                    </div>
                </g:if>
            </g:if>

            <g:if test="${assetInstanceList.size() > 0}">
                <div class="list">
                    <table>
                        <thead>
                            <tr>
                            
                                <g:sortableColumn property="id" title="Id" params="${filterParams}" />

                                <g:sortableColumn property="name" title="Name" params="${filterParams}" />
                            
                                <g:sortableColumn property="description" title="Description" params="${filterParams}" />

                                <g:sortableColumn property="isActive" title="Is Active" params="${filterParams}" />
                            
                                <g:sortableColumn property="section" title="Section" params="${filterParams}" />

                                <th></th>
                            
                            </tr>
                        </thead>
                        <tbody>
                        <g:each in="${assetInstanceList}" status="i" var="assetInstance">
                            <tr class="${(i % 2) == 0 ? 'clickableOdd' : 'clickableEven'}" onclick='window.location = "${request.getContextPath()}/assetDetailed/show/${assetInstance.id}"'/>
                            
                                <td>${fieldValue(bean:assetInstance, field:'id')}</td>

                                <td>${fieldValue(bean:assetInstance, field:'name')}</td>

                                <td>${fieldValue(bean:assetInstance, field:'description')}</td>

                                <td>${fieldValue(bean:assetInstance, field:'isActive')}</td>

                                <td>${fieldValue(bean:assetInstance, field:'section')}</td>

                                <td>
                                    <g:link action="show" id="${assetInstance.id}">
                                        <img  src="${resource(dir:'images/skin',file:'database_go.png')}" alt="Show" />
                                    </g:link>
                                </td>
                            
                            </tr>
                        </g:each>
                        </tbody>
                    </table>
                </div>
            </g:if>
            <div class="paginateButtons">
                <g:paginate total="${assetInstanceTotal}" params="${filterParams}" />
            </div>

            <filterpane:filterPane domainBean="Asset"
                                    title="Search"
                                    action="search"
                                    class="overlayPane"
                                    excludeProperties=""
                                    associatedProperties="section.name"
                                    filterPropertyValues="${['section.name':[values:Section.list()] ]}" />
        </div> <!-- end body div -->
    </body>
</html>
