<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>Task Search</title>
        <filterpane:includes />
        <nav:resources override="true"/>
        <export:resource />
    </head>
    <body>
        <div class="nav">
            <nav:renderSubItems group="nav"/>
        </div>

        <div class="body">
            <g:render template="/shared/messages" />
            <g:hasErrors bean="${appCore}">
                <div class="errors">
                    <g:renderErrors bean="${appCore}" as="list" />
                </div>
            </g:hasErrors>
            <filterpane:currentCriteria domainBean="Task"
                                    action="search"
                                    dateFormat="EEE, dd-MMM-yyyy"
                                    removeImgDir="images"
                                    removeImgFile="bullet_delete.png"
                                    title="Advanced Search"/>

            <div class="paginateButtons">
                <span class="searchButtons">
                    <a href='' onclick="showElement('searchPane'); return false;">Quick</a>
                </span>
                Results: ${taskInstanceList.size()} / ${taskInstanceTotal}
                <span class="searchButtons">
                    <filterpane:filterButton text="Advanced" appliedText="Advanced" />
                </span>
            </div>

            <jsUtil:toggleControl toggleId="options"
                                                    imageId="optionsImg"
                                                    closedImgUrl="${resource(dir:'images/skin',file:'bullet_arrow_right.png')}"
                                                    openImgUrl="${resource(dir:'images/skin',file:'bullet_arrow_down.png')}"
                                                    text="${g.message(code: 'default.options.text')}"
                                                    />

            <div id="options" style="display:none;">
                <g:form method="post" >
                    <g:hiddenField name="params" value="${filterParams}" />
                    <div class="dialog">
                        <table>
                            <tbody>

                                <tr class="prop">
                                    <td valign="top" class="name">
                                        <label for="max">Results per page:</label>
                                    </td>
                                    <td valign="top" class="value">
                                        <input type="text" maxlength="4" id="description" name="newMax" value="${params.max}"/>

                                        <span class="buttons">
                                            <g:actionSubmit action="setSearchParamsMax" class="go" value="Update" />
                                        </span>
                                    </td>
                                </tr>

                            </tbody>
                        </table>
                    </div>
                <export:formats  params="${filterParams}" formats="['csv', 'excel', 'pdf', 'rtf']"/>
                </g:form>
            </div>

            <br />

            <g:if test="${taskInstanceList.size() > 10}">
                <g:if test="${taskInstanceTotal > taskInstanceList.size()}">
                    <div class="paginateButtons">
                        <g:paginate total="${taskInstanceTotal}" params="${filterParams}" />
                    </div>
                </g:if>
            </g:if>

            <g:if test="${taskInstanceList.size() > 0}">
                <div class="list">
                    <table>
                        <thead>
                            <tr>

                                <custom:sortableColumnWithImg property="attentionFlag"
                                                                                                imgSrc="${resource(dir:'images/skin',file:'flag_red.png')}"
                                                                                                imgAlt="Flag" params="${filterParams}" />

                                <g:sortableColumn property="id" title="Id" params="${filterParams}" />

                                <g:sortableColumn property="targetStartDate" title="Target Start Date" params="${filterParams}" />

                                <g:sortableColumn property="description" title="Description" params="${filterParams}" />

                                <g:sortableColumn  property="taskPriority" title="Task Priority" params="${filterParams}" />

                                <g:sortableColumn  property="taskStatus" title="Task Status" params="${filterParams}" />

                                <th></th>

                            </tr>
                        </thead>
                        </tbody>
                        <tbody>
                        <g:each in="${taskInstanceList}" status="i" var="taskInstance">
                        <tr class="${(i % 2) == 0 ? 'clickableOdd' : 'clickableEven'}" onclick='window.location = "${request.getContextPath()}/taskDetailed/show/${taskInstance.id}"'/>

                                <td class="idColumn">
                                    <g:if test="${taskInstance.attentionFlag}">
                                        <img  src="${resource(dir:'images/skin',file:'flag_red.png')}" alt="Flag" />
                                    </g:if>
                                </td>

                                <td class="idColumn">${fieldValue(bean:taskInstance, field:'id')}</td>

                                <td><g:formatDate date="${taskInstance.targetStartDate}" format="EEE, dd-MMM-yyyy"/></td>

                                <td>${fieldValue(bean:taskInstance, field:'description')}</td>

                                <td>${fieldValue(bean:taskInstance, field:'taskPriority')}</td>

                                <td>${fieldValue(bean:taskInstance, field:'taskStatus')}</td>

                                <td>
                                    <g:link action="show" id="${taskInstance.id}">
                                        <img  src="${resource(dir:'images/skin',file:'database_go.png')}" alt="Show" />
                                    </g:link>
                                </td>

                            </tr>
                        </g:each>
                        </tbody>
                    </table>
                </div>
            </g:if>
            <div class="paginateButtons">
                <g:paginate  action="search" total="${taskInstanceTotal}" params="${filterParams}" />
            </div>

            <filterpane:filterPane domainBean="Task"
                                    title="Advanced Search"
                                    action="search"
                                    class="overlayPane"
                                    additionalProperties="id"
                                    associatedProperties="taskPriority.name,
                                                                                leadPerson.lastName,
                                                                                leadPerson.firstName,
                                                                                taskGroup.name,
                                                                                associatedAssets.name,
                                                                                primaryAsset.name,
                                                                                taskStatus.name,
                                                                                taskType.name"
                                    filterPropertyValues="${['taskPriority.name':[values:TaskPriority.list()],
                                                                                'leadPerson.lastName':[values:Person.executeQuery('select distinct t.lastName from Person t')],
                                                                                'leadPerson.firstName':[values:Person.executeQuery('select distinct t.firstName from Person t')],
                                                                                'taskGroup.name':[values:TaskGroup.list()],
                                                                                'associatedAssets.name':[values:Asset.list()],
                                                                                'primaryAsset.name':[values:Asset.list()],
                                                                                'taskStatus.name':[values:TaskStatus.list()],
                                                                                'taskType.name':[values:TaskType.list()],
                                                                                targetCompletionDate:[years:2020..2000,precision:'day'],
                                                                                targetStartDate:[years:2020..2000,precision:'day']
                                                                                ]}"/>

            <g:render template="quickSearchPane" />

        </div> <!-- end body  -->
    </body>
</html>
