import org.codehaus.groovy.grails.plugins.springsecurity.Secured

@Secured(['ROLE_AppAdmin', 'ROLE_Manager'])
class ProductionReferenceDetailedController extends BaseController {

    def index = { redirect(action:list,params:params) }

    // the delete, save and update actions only accept POST requests
    static allowedMethods = [delete:'POST', save:'POST', update:'POST']

    def list = {
        params.max = Math.min( params.max ? params.max.toInteger() : 10,  100)
        [ productionReferenceInstanceList: ProductionReference.list( params ), productionReferenceInstanceTotal: ProductionReference.count() ]
    }

    def show = {
        def productionReferenceInstance = ProductionReference.get( params.id )

        if(!productionReferenceInstance) {
            flash.message = "ProductionReference not found with id ${params.id}"
            redirect(action:list)
        }
        else { return [ productionReferenceInstance : productionReferenceInstance ] }
    }

    def delete = {
        def productionReferenceInstance = ProductionReference.get( params.id )
        if(productionReferenceInstance) {
            try {
                productionReferenceInstance.delete(flush:true)
                flash.message = "ProductionReference ${params.id} deleted"
                redirect(action:list)
            }
            catch(org.springframework.dao.DataIntegrityViolationException e) {
                flash.message = "ProductionReference ${params.id} could not be deleted"
                redirect(action:show,id:params.id)
            }
        }
        else {
            flash.message = "ProductionReference not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def edit = {
        def productionReferenceInstance = ProductionReference.get( params.id )

        if(!productionReferenceInstance) {
            flash.message = "ProductionReference not found with id ${params.id}"
            redirect(action:list)
        }
        else {
            return [ productionReferenceInstance : productionReferenceInstance ]
        }
    }

    def update = {
        def productionReferenceInstance = ProductionReference.get( params.id )
        if(productionReferenceInstance) {
            if(params.version) {
                def version = params.version.toLong()
                if(productionReferenceInstance.version > version) {
                    
                    productionReferenceInstance.errors.rejectValue("version", "default.optimistic.locking.failure")
                    render(view:'edit',model:[productionReferenceInstance:productionReferenceInstance])
                    return
                }
            }
            productionReferenceInstance.properties = params
            if(!productionReferenceInstance.hasErrors() && productionReferenceInstance.save(flush: true)) {
                flash.message = "ProductionReference ${params.id} updated"
                redirect(action:show,id:productionReferenceInstance.id)
            }
            else {
                render(view:'edit',model:[productionReferenceInstance:productionReferenceInstance])
            }
        }
        else {
            flash.message = "ProductionReference not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def create = {
        def productionReferenceInstance = new ProductionReference()
        productionReferenceInstance.properties = params
        return ['productionReferenceInstance':productionReferenceInstance]
    }

    def save = {
        def productionReferenceInstance = new ProductionReference(params)
        if(!productionReferenceInstance.hasErrors() && productionReferenceInstance.save(flush: true)) {
            flash.message = "ProductionReference ${productionReferenceInstance.id} created"
            redirect(action:show,id:productionReferenceInstance.id)
        }
        else {
            render(view:'create',model:[productionReferenceInstance:productionReferenceInstance])
        }
    }
}
