

<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>Edit InventoryItem</title>
        <nav:resources override="true"/>
        <g:render template="/shared/pictureHead" />
    </head>
    <body>
        <div class="nav">
            <nav:renderSubItems group="nav"/>
        </div>
        <div class="body">
            <g:if test="${flash.message}">
            <div class="message">${flash.message}</div>
            </g:if>
            <g:hasErrors bean="${inventoryItemInstance}">
            <div class="errors">
                <g:renderErrors bean="${inventoryItemInstance}" as="list" />
            </div>
            </g:hasErrors>
            <g:form method="post" >
                <input type="hidden" name="id" value="${inventoryItemInstance?.id}" />
                <input type="hidden" name="version" value="${inventoryItemInstance?.version}" />
                <div class="dialog">
                    <table>
                        <tbody>

                            <tr class="prop">
                                <td valign="top" class="name">Picture:</td>
                                <td valign="top" class="value">
                                    <g:if test="${inventoryItemInstance.picture}" >
                                        <span class='gallery'>
                                            <wa:pictureLightboxAnchor picture="${inventoryItemInstance.picture}" size="${Image.Medium}" lightboxSize="${Image.Large}" target="_blank" title="Show Original" />
                                        </span>
                                        <br />
                                        <g:link controller="pictureDetailed" action="edit" id="${inventoryItemInstance.picture.id}" >
                                            Edit Picture
                                        </g:link>
                                    </g:if>
                                </td>
                            </tr>

                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="name">Name:</label>
                                </td>
                                <td valign="top">
                                    <input class="description ${hasErrors(bean:inventoryItemInstance,field:'name','errors')}"
                                                type="text" maxlength="50" id="name" name="name"
                                                value="${fieldValue(bean:inventoryItemInstance,field:'name')}"/>
                                </td>
                            </tr>

                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="description">Description:</label>
                                </td>
                                <td valign="top">
                                    <input class="description ${hasErrors(bean:inventoryItemInstance,field:'description','errors')}"
                                                type="text" id="description" name="description"
                                                value="${fieldValue(bean:inventoryItemInstance,field:'description')}"/>
                                </td>
                            </tr>

                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="unitsInStock">In Stock:</label>
                                </td>
                                <td valign="top" class="value">
                                    ${inventoryItemInstance.unitsInStock} ${inventoryItemInstance.unitOfMeasure.encodeAsHTML()}
                                </td>
                            </tr>

                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="inventoryLocation">Location:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryItemInstance,field:'inventoryLocation','errors')}">
                                    <g:select optionKey="id"
                                                        from="${ InventoryLocation.list().sort { p1, p2 -> p1.toString().compareToIgnoreCase(p2.toString()) } }"
                                                        name="inventoryLocation.id"
                                                        value="${inventoryItemInstance?.inventoryLocation?.id}" >
                                    </g:select>
                                </td>
                            </tr>

                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="isActive">Active:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryItemInstance,field:'isActive','errors')}">
                                    <g:checkBox name="isActive" value="${inventoryItemInstance?.isActive}" ></g:checkBox>
                                </td>
                            </tr>

                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="reorderPoint">Reorder Point:</label>
                                </td>
                                <td valign="top">
                                    <input  class="medium ${hasErrors(bean:inventoryItemInstance,field:'reorderPoint','errors')}"
                                                    type="text" id="reorderPoint" name="reorderPoint"
                                                    value="${fieldValue(bean:inventoryItemInstance,field:'reorderPoint')}" />
                                     ${inventoryItemInstance.unitOfMeasure.encodeAsHTML()}
                                </td>
                            </tr>

                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="recommendedReorderPoint">Recommended Reorder Point:</label>
                                </td>
                                <td valign="top">
                                    <input class="medium ${hasErrors(bean:inventoryItemInstance,field:'recommendedReorderPoint','errors')}"
                                                type="text" id="recommendedReorderPoint" name="recommendedReorderPoint"
                                                value="${fieldValue(bean:inventoryItemInstance,field:'recommendedReorderPoint')}" />
                                     ${inventoryItemInstance.unitOfMeasure.encodeAsHTML()}
                                </td>
                            </tr>

                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="enableReorder">Enable Reorder:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryItemInstance,field:'enableReorder','errors')}">
                                    <g:checkBox name="enableReorder" value="${inventoryItemInstance?.enableReorder}" ></g:checkBox>
                                </td>
                            </tr>

                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="isObsolete">Obsolete:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryItemInstance,field:'isObsolete','errors')}">
                                    <g:checkBox name="isObsolete" value="${inventoryItemInstance?.isObsolete}" ></g:checkBox>
                                </td>
                            </tr>

                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="averageDeliveryTime">Average Delivery Time:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryItemInstance,field:'averageDeliveryTime','errors')}">
                                    <input type="text" id="averageDeliveryTime" name="averageDeliveryTime" value="${fieldValue(bean:inventoryItemInstance,field:'averageDeliveryTime')}" />
                                    <g:select optionKey="id"
                                                        from="${Period.list()}"
                                                        name="averageDeliveryPeriod.id"
                                                        value="${inventoryItemInstance?.averageDeliveryPeriod?.id}"
                                                        noSelection="['null':'--None--']">
                                    </g:select>
                                </td>
                            </tr>

                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="suppliersPartNumber">Suppliers Part Number:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryItemInstance,field:'suppliersPartNumber','errors')}">
                                    <input type="text" id="suppliersPartNumber" name="suppliersPartNumber" value="${fieldValue(bean:inventoryItemInstance,field:'suppliersPartNumber')}"/>
                                </td>
                            </tr>

                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="suppliers">Suppliers:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryItemInstance,field:'suppliers','errors')}">
                                    <g:select id="suppliers" name="suppliers"
                                                        from="${ Supplier.list().sort { p1, p2 -> p1.name.compareToIgnoreCase(p2.name) } }"
                                                        size="5" multiple="yes" optionKey="id"
                                                        value="${inventoryItemInstance?.suppliers.id}" noSelection="['':'--None--']"/>

                                <p><g:link controller="supplierDetailed" action="create">add Supplier</g:link></p>
                                </td>
                            </tr>

                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="manufacturersPartNumber">Manufacturers Part Number:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryItemInstance,field:'manufacturersPartNumber','errors')}">
                                    <input type="text" id="manufacturersPartNumber" name="manufacturersPartNumber" value="${fieldValue(bean:inventoryItemInstance,field:'manufacturersPartNumber')}"/>
                                </td>
                            </tr>

                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="manufacturers">Manufacturers:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryItemInstance,field:'manufacturers','errors')}">
                                    <g:select id="manufacturers" name="manufacturers"
                                                        from="${ Manufacturer.list().sort { p1, p2 -> p1.name.compareToIgnoreCase(p2.name) } }"
                                                        size="5" multiple="yes" optionKey="id"
                                                        value="${inventoryItemInstance?.manufacturers.id}" noSelection="['':'--None--']"/>

                                    <p><g:link controller="manufacturerDetailed" action="create">add Manufacturer</g:link></p>
                                </td>
                            </tr>

                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="spareFor">Spare For:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryItemInstance,field:'spareFor','errors')}">
                                    <g:select name="spareFor"
                                                        from="${ Asset.list().sort { p1, p2 -> p1.name.compareToIgnoreCase(p2.name) } }"
                                                        size="5" multiple="yes" optionKey="id"
                                                        value="${inventoryItemInstance?.spareFor.id}" noSelection="['':'--None--']"/>

                                </td>
                            </tr>

                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="alternateItems">Alternate Items:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryItemInstance,field:'alternateItems','errors')}">
                                    <g:select name="alternateItems"
                                                        from="${ InventoryItem.list().sort { p1, p2 -> p1.name.compareToIgnoreCase(p2.name) } }"
                                                        size="5" multiple="yes" optionKey="id"
                                                        value="${inventoryItemInstance?.alternateItems.id}" noSelection="['':'--None--']"/>

                                </td>
                            </tr>

                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="inventoryGroup">Inventory Group:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryItemInstance,field:'inventoryGroup','errors')}">
                                    <g:select optionKey="id" from="${InventoryGroup.list()}" name="inventoryGroup.id" value="${inventoryItemInstance?.inventoryGroup?.id}" ></g:select>
                                </td>
                            </tr>

                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="inventoryType">Inventory Type:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryItemInstance,field:'inventoryType','errors')}">
                                    <g:select optionKey="id" from="${InventoryType.list()}" name="inventoryType.id" value="${inventoryItemInstance?.inventoryType?.id}" ></g:select>
                                </td>
                            </tr>

                        </tbody>
                    </table>
                </div>
                <div class="buttons">
                    <span class="button"><g:actionSubmit class="save" value="Update" /></span>
                    <span class="button"><g:actionSubmit class="cancel" value="Cancel" action="Show"/></span>
                    <span class="button"><g:actionSubmit class="delete" onclick="return confirm('Are you sure?');" value="Delete" /></span>
                </div>
            </g:form>
        </div>
    </body>
</html>
