

<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>Edit TaskRecurringSchedule</title>
        <resource:dateChooser />
    </head>
    <body>
        <div class="nav">
            <h1>Edit Recurring Schedule</h1>
        </div>
        <div class="body">
            <g:if test="${flash.message}">
            <div class="message">${flash.message}</div>
            </g:if>
            <g:hasErrors bean="${taskRecurringScheduleInstance}">
            <div class="errors">
                <g:renderErrors bean="${taskRecurringScheduleInstance}" as="list" />
            </div>
            </g:hasErrors>
            <g:form method="post" >
                <input type="hidden" name="id" value="${taskRecurringScheduleInstance?.id}" />
                <input type="hidden" name="version" value="${taskRecurringScheduleInstance?.version}" />
                <div class="dialog">
                    <table>
                        <tbody>

                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="recForTask">Recurring Schedule for Task:</label>
                                </td>
                                <td valign="top" name="recForTask" class="value">
                                    <g:link controller="taskDetailed" action="show" id="${taskRecurringScheduleInstance?.task?.id}">${taskRecurringScheduleInstance?.task?.encodeAsHTML()}</g:link>
                                </td>
                            </tr>
                            
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="nextTargetStartDate">Next Target Start Date:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskRecurringScheduleInstance,field:'nextTargetStartDate','errors')}">
                                    <richui:dateChooser name="nextTargetStartDate" format="dd-MM-yyyy" value="${taskRecurringScheduleInstance?.nextTargetStartDate}" />
                                    <g:helpBalloon class="helpballoon" code="taskRecurringSchedule.nextTargetStartDate" />
                                </td>
                            </tr>   
                      
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="recurEvery">Recur Every:</label>
                                </td>
                                <td valign="top" class="value" >
                                    <input type="text" class="time ${hasErrors(bean:taskRecurringScheduleInstance,field:'recurEvery','errors')}"
                                        id="recurEvery" name="recurEvery" value="${fieldValue(bean:taskRecurringScheduleInstance,field:'recurEvery')}" />
                                    <g:select optionKey="id" from="${Period.list()}" name="recurPeriod.id" value="${taskRecurringScheduleInstance?.recurPeriod?.id}" ></g:select>
                                    <g:helpBalloon class="helpballoon" code="taskRecurringSchedule.recurEvery" />
                                </td>
                            </tr>   
                      
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="taskDuration">Task Duration:</label>
                                </td>
                                <td valign="top" class="value" >
                                    <input type="text" class="time ${hasErrors(bean:taskRecurringScheduleInstance,field:'taskDuration','errors')}"
                                        id="taskDuration" name="taskDuration" value="${fieldValue(bean:taskRecurringScheduleInstance,field:'taskDuration')}" />
                                    <g:select optionKey="id" from="${Period.list()}" name="taskDurationPeriod.id" value="${taskRecurringScheduleInstance?.taskDurationPeriod?.id}" ></g:select>
                                    <g:helpBalloon class="helpballoon" code="taskRecurringSchedule.taskDuration" />
                                </td>
                            </tr>       
                      
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="generateAhead">Generate Ahead:</label>
                                </td>
                                <td valign="top" class="value" >
                                    <input type="text" class="time ${hasErrors(bean:taskRecurringScheduleInstance,field:'generateAhead','errors')}"
                                        id="generateAhead" name="generateAhead" value="${fieldValue(bean:taskRecurringScheduleInstance,field:'generateAhead')}" />
                                        ${Period.get(1).encodeAsHTML()}
                                        <g:helpBalloon class="helpballoon" code="taskRecurringSchedule.generateAhead" />
                                </td>
                            </tr>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="enabled">Enabled:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskRecurringScheduleInstance,field:'enabled','errors')}">
                                    <g:checkBox name="enabled" value="${taskRecurringScheduleInstance?.enabled}" ></g:checkBox>
                                        <g:helpBalloon class="helpballoon" code="taskRecurringSchedule.enabled" />
                                </td>
                            </tr>
                        
                        </tbody>
                    </table>
                </div>
                <div class="buttons">
                    <span class="button"><g:actionSubmit class="save" value="Update" /></span>
<!--                     <span class="button"><g:actionSubmit class="delete" onclick="return confirm('Are you sure?');" value="Delete" /></span> -->
                </div>
            </g:form>
        </div>
    </body>
</html>
