

<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>Edit AssetSubItem</title>
        <nav:resources override="true"/>
    </head>
    <body>
        <div class="nav">
            <nav:renderSubItems group="navAlt"/>
        </div>
        <div class="body">
            <g:render template="/shared/messages" />
            <g:hasErrors bean="${assetSubItemInstance}">
            <div class="errors">
                <g:renderErrors bean="${assetSubItemInstance}" as="list" />
            </div>
            </g:hasErrors>
            <g:form method="post" >
                <input type="hidden" name="id" value="${assetSubItemInstance?.id}" />
                <input type="hidden" name="version" value="${assetSubItemInstance?.version}" />
                <div class="dialog">
                    <table>
                        <tbody>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="name">Name:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:assetSubItemInstance,field:'name','errors')}">
                                    <input type="text" class="description" maxlength="50" id="name" name="name" value="${fieldValue(bean:assetSubItemInstance,field:'name')}"/>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="description">Description:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:assetSubItemInstance,field:'description','errors')}">
                                    <input type="text" class="description" maxlength="75" id="description" name="description" value="${fieldValue(bean:assetSubItemInstance,field:'description')}"/>
                                </td>
                            </tr>
                            
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="comment">Comment:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:assetSubItemInstance,field:'comment','errors')}">
                                    <textarea rows="5" cols="40" name="comment">${fieldValue(bean:assetSubItemInstance, field:'comment')}</textarea>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="isActive">Is Active:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:assetSubItemInstance,field:'isActive','errors')}">
                                    <g:checkBox name="isActive" value="${assetSubItemInstance?.isActive}" ></g:checkBox>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="assetSubItemExtendedAttributes">Asset Sub Item Extended Attributes:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:assetSubItemInstance,field:'assetSubItemExtendedAttributes','errors')}">
                                    
<ul>
<g:each var="a" in="${assetSubItemInstance?.assetSubItemExtendedAttributes?}">
    <li><g:link controller="assetSubItemExtendedAttributeDetailed" action="show" id="${a.id}">${a?.encodeAsHTML()}</g:link></li>
</g:each>
</ul>
<g:link controller="assetSubItemExtendedAttributeDetailed" params="['assetSubItem.id':assetSubItemInstance?.id]" action="create">Add AssetSubItemExtendedAttribute</g:link>

                                </td>
                            </tr>
                        
                            <tr class="prop">
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="maintenanceActions">Maintenance Actions:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:assetSubItemInstance,field:'maintenanceActions','errors')}">
                                    
<ul>
<g:each var="m" in="${assetSubItemInstance?.maintenanceActions?}">
    <li><g:link controller="maintenanceActionDetailed" action="show" id="${m.id}">${m?.encodeAsHTML()}</g:link></li>
</g:each>
</ul>
<g:link controller="maintenanceActionDetailed" params="['assetSubItem.id':assetSubItemInstance?.id]" action="create">Add MaintenanceAction</g:link>

                                </td>
                            </tr>

                            
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="parentItem">Parent Item:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:assetSubItemInstance,field:'parentItem','errors')}">
                                    <g:if test="${assetSubItemInstance.assets}">
                                        Assigned to assets.
                                    </g:if>
                                    <g:else>
                                        <g:select optionKey="id" from="${possibleParentItems}" name="parentItem.id" value="${assetSubItemInstance?.parentItem?.id}" noSelection="['null':'--None--']"></g:select>
                                    </g:else>
                                </td>
                            </tr>

                            <tr class="prop">
                                <td valign="top" class="name">Assets:</td>

                                <td  valign="top" style="text-align:left;" class="value">
                                    <g:if test="${assetSubItemInstance.parentItem}" >
                                        Assigned to parent item.
                                    </g:if>
                                    <g:else>
                                        <ul>
                                        <g:each var="a" in="${assetSubItemInstance.assets}">
                                            <li><g:link controller="assetDetailed" action="show" id="${a.id}">${a?.encodeAsHTML()}</g:link></li>
                                        </g:each>
                                        </ul>
                                    </g:else>
                                </td>

                            </tr>

                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="subItems">Sub Items:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:assetSubItemInstance,field:'subItems','errors')}">
                                    
<ul>
<g:each var="s" in="${assetSubItemInstance?.subItems?}">
    <li><g:link controller="assetSubItemDetailed" action="show" id="${s.id}">${s?.encodeAsHTML()}</g:link></li>
</g:each>
</ul>
<g:link controller="assetSubItemDetailed" params="['parentItem.id':assetSubItemInstance?.id]" action="create">Add AssetSubItem</g:link>

                                </td>
                            </tr> 
                        
                        </tbody>
                    </table>
                </div>
                <div class="buttons">
                    <span class="button"><g:actionSubmit class="save" value="Update" /></span>
                    <span class="button"><g:actionSubmit class="cancel" value="Cancel" action="Show"/></span>
                    <span class="button"><g:actionSubmit class="delete" onclick="return confirm('Are you sure?');" value="Delete" /></span>
                </div>
            </g:form>
        </div>
    </body>
</html>
