

<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>Edit Site</title>
    </head>
    <body>
        <div class="nav">
            <span class="menuButton"><g:link class="list" action="list">Site List</g:link></span>
            <span class="menuButton"><g:link class="create" action="create">New Site</g:link></span>
        </div>
        <div class="body">
            <h1>Edit Site</h1>
            <g:render template="/shared/messages" />
            <g:hasErrors bean="${siteInstance}">
            <div class="errors">
                <g:renderErrors bean="${siteInstance}" as="list" />
            </div>
            </g:hasErrors>
            <g:form method="post" >
                <input type="hidden" name="id" value="${siteInstance?.id}" />
                <input type="hidden" name="version" value="${siteInstance?.version}" />
                <div class="dialog">
                    <table>
                        <tbody>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="name">Name:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:siteInstance,field:'name','errors')}">
                                    <input type="text" class="description" maxlength="50" id="name" name="name" value="${fieldValue(bean:siteInstance,field:'name')}"/>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="description">Description:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:siteInstance,field:'description','errors')}">
                                    <input type="text" class="description" maxlength="75" id="description" name="description" value="${fieldValue(bean:siteInstance,field:'description')}"/>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="comment">Comment:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:siteInstance,field:'comment','errors')}">
                                    <textarea rows="5" cols="40" name="comment">${fieldValue(bean:siteInstance, field:'comment')}</textarea>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="isActive">Is Active:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:siteInstance,field:'isActive','errors')}">
                                    <g:checkBox name="isActive" value="${siteInstance?.isActive}" ></g:checkBox>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="inventoryStores">Inventory Stores:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:siteInstance,field:'inventoryStores','errors')}">
                                    
<ul>
<g:each var="i" in="${siteInstance?.inventoryStores?}">
    <li><g:link controller="inventoryStoreDetailed" action="show" id="${i.id}">${i?.encodeAsHTML()}</g:link></li>
</g:each>
</ul>
<g:link controller="inventoryStoreDetailed" params="['site.id':siteInstance?.id]" action="create">Add InventoryStore</g:link>

                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="sections">Sections:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:siteInstance,field:'sections','errors')}">
                                    
<ul>
<g:each var="s" in="${siteInstance?.sections?}">
    <li><g:link controller="sectionDetailed" action="show" id="${s.id}">${s?.encodeAsHTML()}</g:link></li>
</g:each>
</ul>
<g:link controller="sectionDetailed" params="['site.id':siteInstance?.id]" action="create">Add Section</g:link>

                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="siteExtendedAttributes">Site Extended Attributes:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:siteInstance,field:'siteExtendedAttributes','errors')}">
                                    
<ul>
<g:each var="s" in="${siteInstance?.siteExtendedAttributes?}">
    <li><g:link controller="siteExtendedAttributeDetailed" action="show" id="${s.id}">${s?.encodeAsHTML()}</g:link></li>
</g:each>
</ul>
<g:link controller="siteExtendedAttributeDetailed" params="['site.id':siteInstance?.id]" action="create">Add SiteExtendedAttribute</g:link>

                                </td>
                            </tr> 
                        
                        </tbody>
                    </table>
                </div>
                <div class="buttons">
                    <span class="button"><g:actionSubmit class="save" value="Update" /></span>
                    <span class="button"><g:actionSubmit class="delete" onclick="return confirm('Are you sure?');" value="Delete" /></span>
                </div>
            </g:form>
        </div>
    </body>
</html>
