<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>Task Search</title>
        <filterpane:includes />
        <nav:resources override="true"/>
        <export:resource />
    </head>
    <body>
        <div class="nav">
            <nav:renderSubItems group="nav"/>
        </div>

        <div class="body">
            <g:if test="${flash.message}">
                <div class="message">${flash.message}</div>
            </g:if>
            <g:if test="${params.message}">
                <div class="message">${params.message}</div>
            </g:if>
            <g:hasErrors bean="${appCore}">
                <div class="errors">
                    <g:renderErrors bean="${appCore}" as="list" />
                </div>
            </g:hasErrors>
            <filterpane:currentCriteria domainBean="Task"
                                    action="search"
                                    dateFormat="${'EEE, dd-MMM-yyyy'}"
                                    removeImgDir="images" 
                                    removeImgFile="bullet_delete.png"
                                    title="Advanced Search"/>

            <div class="paginateButtons">
                <span class="searchButtons">
                    <a href='' onclick="showElement('searchPane'); return false;">Quick</a>
                </span>
                Results: ${taskInstanceList.size()} / ${taskInstanceTotal}
                <span class="searchButtons">
                    <filterpane:filterButton text="Advanced" appliedText="Advanced" />
                </span>
            </div>

            <jsUtil:toggleControl toggleId="options"
                                                    imageId="optionsImg"
                                                    closedImgUrl="${resource(dir:'images/skin',file:'bullet_arrow_right.png')}"
                                                    openImgUrl="${resource(dir:'images/skin',file:'bullet_arrow_down.png')}"
                                                    text="${g.message(code: 'default.options.text')}"
                                                    />

            <div id="options" style="display:none;">
                <g:form method="post" >
                    <g:hiddenField name="params" value="${filterParams}" />
                    <div class="dialog">
                        <table>
                            <tbody>

                                <tr class="prop">
                                    <td valign="top" class="name">
                                        <label for="max">Results per page:</label>
                                    </td>
                                    <td valign="top" class="value">
                                        <input type="text" maxlength="4" id="description" name="newMax" value="${params.max}"/>

                                        <span class="buttons">
                                            <g:actionSubmit action="setSearchParamsMax" class="go" value="Update" />
                                        </span>
                                    </td>
                                </tr>

                            </tbody>
                        </table>
                    </div>
                <export:formats  params="${filterParams}" formats="['csv', 'excel', 'pdf', 'rtf']"/>
                </g:form>
            </div>

            <br />

            <g:if test="${taskInstanceList.size() > 10}">
                <div class="paginateButtons">
                    <g:paginate total="${taskInstanceTotal}" params="${filterParams}" />
                </div>
            </g:if>

            <div class="list">
                <table>
                    <thead>
                        <tr>

                            <g:sortableColumn property="id" title="Id" params="${filterParams}" />

                            <g:sortableColumn property="targetStartDate" title="Target Start Date" params="${filterParams}" />

                            <g:sortableColumn property="description" title="Description" params="${filterParams}" />

                            <g:sortableColumn  property="leadPerson" title="Lead Person" params="${filterParams}" />

                            <g:sortableColumn  property="taskPriority" title="Task Priority" params="${filterParams}" />

                            <g:sortableColumn  property="taskStatus" title="Task Status" params="${filterParams}" />

                            <th></th>

                        </tr>
                    </thead>
                    <tbody>
                    <g:each in="${taskInstanceList}" status="i" var="taskInstance">
                    <tr class="${(i % 2) == 0 ? 'clickableOdd' : 'clickableEven'}" onclick='window.location = "${request.getContextPath()}/taskDetailed/show/${taskInstance.id}"'/>

                            <td>${fieldValue(bean:taskInstance, field:'id')}</td>

                            <td><g:formatDate date="${taskInstance.targetStartDate}" format="EEE, dd-MMM-yyyy"/></td>

                            <td>${fieldValue(bean:taskInstance, field:'description')}</td>

                            <td>${fieldValue(bean:taskInstance, field:'leadPerson')}</td>

                            <td>${fieldValue(bean:taskInstance, field:'taskPriority')}</td>

                            <td>${fieldValue(bean:taskInstance, field:'taskStatus')}</td>

                            <td>
                                <g:link action="show" id="${taskInstance.id}">
                                    <img  src="${resource(dir:'images/skin',file:'database_go.png')}" alt="Show" />
                                </g:link>
                            </td>

                        </tr>
                    </g:each>
                    </tbody>
                </table>
            </div>
            <div class="paginateButtons">
                <g:paginate total="${taskInstanceTotal}" params="${filterParams}" />
            </div>

            <filterpane:filterPane domainBean="Task"
                                    title="Advanced Search"
                                    action="search"
                                    class="overlayPane"
                                    additionalProperties="id"
                                    associatedProperties="taskPriority.name,
                                                                                leadPerson.lastName,
                                                                                leadPerson.firstName,
                                                                                taskGroup.name,
                                                                                associatedAssets.name,
                                                                                primaryAsset.name,
                                                                                taskStatus.name,
                                                                                taskType.name"
                                    filterPropertyValues="${['taskPriority.name':[values:TaskPriority.list()],
                                                                                'leadPerson.lastName':[values:Person.executeQuery('select distinct t.lastName from Person t')],
                                                                                'leadPerson.firstName':[values:Person.executeQuery('select distinct t.firstName from Person t')],
                                                                                'taskGroup.name':[values:TaskGroup.list()],
                                                                                'associatedAssets.name':[values:Asset.list()],
                                                                                'primaryAsset.name':[values:Asset.list()],
                                                                                'taskStatus.name':[values:TaskStatus.list()],
                                                                                'taskType.name':[values:TaskType.list()],
                                                                                targetCompletionDate:[years:2020..2000,precision:'day'],
                                                                                targetStartDate:[years:2020..2000,precision:'day']
                                                                                ]}"/>
        </div> <!-- end body  -->

        <!-- Start Search Pane -->
        <div class="overlayPane" id="searchPane" style="display:none;">
            <h2>Quick Search</h2>
            <g:form method="post" id="searchForm" name="searchForm" >
                <table>
                    <tbody>

                        <tr class="prop">
                            <td valign="top" class="name">
                                <label>My Tasks:</label>
                            </td>
                            <td valign="top" class="value">
                                <g:link controller="taskDetailed"
                                                action="search"
                                                params="[quickSearch: 'searchMyTodays']">
                                                Today's
                                </g:link>
                                <br />
                                <g:link controller="taskDetailed" 
                                                action="search"
                                                params="[quickSearch: 'searchMyInTheLastWeek']">
                                                In the last week
                                </g:link>
                            </td>
                        </tr>

                        <tr class="prop">
                            <td valign="top" class="name">
                                <label>Tasks:</label>
                            </td>
                            <td valign="top" class="value">
                                <g:link controller="taskDetailed"
                                                action="search"
                                                params="[quickSearch: 'searchTodays']">
                                                Today's
                                </g:link>
                                <br />
                                <g:link controller="taskDetailed" 
                                                action="search"
                                                params="[quickSearch: 'searchInTheLastWeek']">
                                                In the last week
                                </g:link>
                            </td>
                        </tr>

                    </tbody>
                </table>
                <div class="buttons">
                    <span class="button">
                        <input type="button" value="${g.message(code:'fp.tag.filterPane.button.cancel.text', default:'Cancel')}" onclick="return hideElement('searchPane');" />
                    </span>
<!--                    <span class="button">
                        <input type="button" value="${g.message(code:'fp.tag.filterPane.button.clear.text', default:'Clear')}" onclick="return clearFilterPane('searchForm');" />
                    </span>
                    <span class="button">
                        <g:actionSubmit class="search" value="Search" />
                    </span>-->
                </div>
            </g:form>
        </div> <!-- end search pane -->

    </body>
</html>
