

<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>AssetSubItem Search</title>
        <nav:resources override="true"/>
        <filterpane:includes />
        <export:resource />
    </head>
    <body>
        <div class="nav">
            <span class="menuButton"><g:link class="create" action="create">New Sub Item</g:link></span>
        </div>
        <div class="body">
            <h1>Sub Item Search</h1>
            <g:render template="/shared/messages" />

            <filterpane:currentCriteria domainBean="AssetSubItem"
                                    action="search"
                                    dateFormat="${'EEE, dd-MMM-yyyy'}"
                                    removeImgDir="images" 
                                    removeImgFile="bullet_delete.png"
                                    title="Search"/>

            <div class="paginateButtons">
                Results: ${assetSubItemInstanceList.size()} / ${assetSubItemInstanceTotal}
                <span class="searchButtons">
                    <filterpane:filterButton text="Search" appliedText="Change Search" />
                </span>
            </div>

            <div class="list">
                <table>
                    <thead>
                        <tr>
                        
                   	        <g:sortableColumn property="id" title="Id" params="${filterParams}" />

                             <g:sortableColumn property="name" title="Name" params="${filterParams}" />
                        
                            <g:sortableColumn property="description" title="Description" params="${filterParams}" />

                            <g:sortableColumn property="isActive" title="Is Active" params="${filterParams}" />

                            <th></th>
                   	    
                        </tr>
                    </thead>
                    <tbody>
                    <g:each in="${assetSubItemInstanceList}" status="i" var="assetSubItemInstance">
                        <tr class="${(i % 2) == 0 ? 'clickableOdd' : 'clickableEven'}" onclick='window.location = "${request.getContextPath()}/assetSubItemDetailed/show/${assetSubItemInstance.id}"'/>
                        
                            <td>${fieldValue(bean:assetSubItemInstance, field:'id')}</td>

                            <td>${fieldValue(bean:assetSubItemInstance, field:'name')}</td>

                            <td>${fieldValue(bean:assetSubItemInstance, field:'description')}</td>

                            <td>${fieldValue(bean:assetSubItemInstance, field:'isActive')}</td>

                            <td>
                                <g:link action="show" id="${assetSubItemInstance.id}">
                                    <img  src="${resource(dir:'images/skin',file:'database_go.png')}" alt="Show" />
                                </g:link>
                            </td>
                        
                        </tr>
                    </g:each>
                    </tbody>
                </table>
            </div>
            <div class="paginateButtons">
                <g:paginate total="${assetSubItemInstanceTotal}" params="${filterParams}" />
            </div>

            <export:formats  params="${filterParams}" formats="['csv', 'excel', 'pdf', 'rtf']"/>

            <filterpane:filterPane domainBean="AssetSubItem"
                                    title="Search"
                                    action="search"
                                    class="overlayPane"
                                    excludeProperties="" />
        </div> <!-- end body div -->
    </body>
</html>
